/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.world;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.block.PalladiumBlocks;
import net.threetag.palladium.world.PalladiumFeatures;
import net.threetag.palladium.world.UndergroundMeteoriteFeature;

public class PalladiumConfiguredFeatures {
    public static final Supplier<List<OreConfiguration.TargetBlockState>> LEAD_ORE_REPLACEMENTS = Suppliers.memoize(() -> List.of(OreConfiguration.m_161021_((RuleTest)new TagMatchTest(BlockTags.f_144266_), (BlockState)((Block)PalladiumBlocks.LEAD_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)new TagMatchTest(BlockTags.f_144267_), (BlockState)((Block)PalladiumBlocks.DEEPSLATE_LEAD_ORE.get()).m_49966_())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> METEORITE_REPLACEMENTS = Suppliers.memoize(() -> List.of(OreConfiguration.m_161021_((RuleTest)new TagMatchTest(BlockTags.f_13061_), (BlockState)Blocks.f_50730_.m_49966_())));
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_LEAD = PalladiumConfiguredFeatures.registerKey("ore_lead");
    public static final ResourceKey<ConfiguredFeature<?, ?>> UNDERGROUND_VIBRANIUM_METEORITE = PalladiumConfiguredFeatures.registerKey("underground_vibranium_meteorite");

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        PalladiumConfiguredFeatures.register(context, ORE_LEAD, Feature.f_65731_, new OreConfiguration(LEAD_ORE_REPLACEMENTS.get(), 9));
        PalladiumConfiguredFeatures.register(context, UNDERGROUND_VIBRANIUM_METEORITE, (UndergroundMeteoriteFeature)((Object)PalladiumFeatures.UNDERGROUND_VIBRANIUM_METEORITE.get()), new OreConfiguration(METEORITE_REPLACEMENTS.get(), 3));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)Palladium.id(name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

