param (
    [string]$speedsterName = "default_runner"
)

# Root path is where the script is located
$rootPath = Split-Path -Parent $MyInvocation.MyCommand.Definition

# List of relative file paths to create
$filePaths = @(
    "addon/arrzenhanced/suit_sets/tachyon_$($speedsterName).json",
    "addon/arrzenhanced/suit_sets/speedster_$($speedsterName).json",
    "assets/arrzenhanced/models/item/tachyon_$($speedsterName)_helmet.json",
    "assets/arrzenhanced/models/item/tachyon_$($speedsterName)_chestplate.json",
    "assets/arrzenhanced/models/item/tachyon_$($speedsterName)_leggings.json",
    "assets/arrzenhanced/models/item/tachyon_$($speedsterName)_boots.json",
    "assets/arrzenhanced/models/item/speedster_$($speedsterName)_helmet.json",
    "assets/arrzenhanced/models/item/speedster_$($speedsterName)_chestplate.json",
    "assets/arrzenhanced/models/item/speedster_$($speedsterName)_leggings.json",
    "assets/arrzenhanced/models/item/speedster_$($speedsterName)_boots.json",
    "assets/arrzenhanced/palladium/armor_renderers/speedsters/$($speedsterName)/helmet_tachyon.json",
    "assets/arrzenhanced/palladium/armor_renderers/speedsters/$($speedsterName)/chest_tachyon.json",
    "assets/arrzenhanced/palladium/armor_renderers/speedsters/$($speedsterName)/legs_tachyon.json",
    "assets/arrzenhanced/palladium/armor_renderers/speedsters/$($speedsterName)/boots_tachyon.json"
    "assets/arrzenhanced/palladium/armor_renderers/speedsters/$($speedsterName)/helmet.json",
    "assets/arrzenhanced/palladium/armor_renderers/speedsters/$($speedsterName)/chest.json",
    "assets/arrzenhanced/palladium/armor_renderers/speedsters/$($speedsterName)/legs.json",
    "assets/arrzenhanced/palladium/armor_renderers/speedsters/$($speedsterName)/boots.json"
)

# Example contents for different file types (you can customize further)
$contentTemplates = @{
    "suit_sets" = @"
{
    "armor_material": "arrzenhanced:speedster_suit",
    "chest": {
        "item_name": "tachyon_$($speedsterName)_chestplate",
        "max_stack_size": 1,
        "is_fire_resistant": false,
        "armor_renderer": "arrzenhanced:speedsters/$($speedsterName)/chest_tachyon"
    },
    "legs": {
        "item_name": "tachyon_$($speedsterName)_leggings",
        "max_stack_size": 1,
        "is_fire_resistant": false,
        "armor_renderer": "arrzenhanced:speedsters/$($speedsterName)/legs_tachyon"
    },
    "feet": {
        "item_name": "tachyon_$($speedsterName)_boots",
        "max_stack_size": 1,
        "is_fire_resistant": false,
        "armor_renderer": "arrzenhanced:speedsters/$($speedsterName)/boots_tachyon"
    },
    "head": {
        "item_name": "tachyon_$($speedsterName)_helmet",
        "max_stack_size": 1,
        "is_fire_resistant": false,
        "armor_renderer": "arrzenhanced:speedsters/$($speedsterName)/helmet_tachyon"
    }
}
"@
    "models_item" = @"
{
  "parent": "minecraft:item/generated",
  "textures": {
    "layer0": "arrzenhanced:item/todo"
  }
}
"@
    "armor_renderers" = @"
{
    "textures": "arrzenhanced:textures/models/armor/speedsters/$($speedsterName)/legs.png",
    "model_layers": "palladium:humanoid#tight_suit",
    "hide_second_layer": true
}
"@
}

foreach ($relPath in $filePaths) {
    $fullPath = Join-Path $rootPath $relPath
    $folderPath = Split-Path $fullPath -Parent

    # Create the directory if it doesn't exist
    if (!(Test-Path $folderPath)) {
        New-Item -ItemType Directory -Path $folderPath -Force | Out-Null
    }

    # Decide what content to write based on path
    if ($relPath -like "*suit_sets*") {
        $content = $contentTemplates["suit_sets"]
    } elseif ($relPath -like "*models/item*") {
        $content = $contentTemplates["models_item"]
    } elseif ($relPath -like "*armor_renderers*") {
        $content = $contentTemplates["armor_renderers"]
    } else {
        $content = "Generic file for $speedsterName"
    }

    # Create and write to the file
    Set-Content -Path $fullPath -Value $content -Force
    Write-Host "Created file: $relPath"
}
