/*
    @author Hertz
    @version 1.0
*/

function resolveAllegedBooleanFromObject(thing) {
    if (thing.toString() == 'true') { return true; }
    if (thing.toString() == 'false') { return false; }
    return null
}
var KJSUtils = Java.loadClass('dev.latvian.mods.kubejs.util.UtilsJS');

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('hertz:asgardian_ascend')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .addProperty('elevate', 'boolean', true, 'True, give stormbreaker and armor. False, take.')
    .firstTick((entity, entry, holder, enabled) => {
        if (enabled) {
            const elevate = resolveAllegedBooleanFromObject(entry.getPropertyByName('elevate'));
            if (elevate) {
                var px = entity.getX();
                var py = entity.getY();
                var pz = entity.getZ();
                var level = entity.getLevel()
                var mob = level.createEntity("minecraft:lightning_bolt");
                mob.setPosition(px, py+1, pz);
                mob.spawn();
            }
        }
    })
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            const elevate = resolveAllegedBooleanFromObject(entry.getPropertyByName('elevate'));
            if (elevate) {
                var inventory = entity.getInventory()
                if (
                    // entity.mainHandItem.is(Item.of('minecraft:air')) && // hand
                    inventory.getArmor(0) == 'minecraft:air' && // boot
                    inventory.getArmor(1) == 'minecraft:air' && // leg
                    inventory.getArmor(2) == 'minecraft:air' // chest
                ) {
                    // entity.setMainHandItem(Item.of('arrzenhanced:stormbreaker'))
                    if (!entity.persistentData['stormbreakerNBT']) {
                        entity.give(Item.of('arrzenhanced:stormbreaker'))
                    } else {
                        entity.give(Item.of('arrzenhanced:stormbreaker', 1, entity.persistentData['stormbreakerNBT']))
                    }
                    if (!entity.persistentData['thorArmor']) {
                        entity.setItemSlot(2, Item.of('arrzenhanced:sabri_boots'))
                        entity.setItemSlot(3, Item.of('arrzenhanced:sabri_leggings'))
                        entity.setItemSlot(4, Item.of('arrzenhanced:sabri_chestplate'))
                    } else {
                        entity.setItemSlot(2, Item.of('arrzenhanced:sabri_boots', 1, entity.persistentData['thorArmor'].boots))
                        entity.setItemSlot(3, Item.of('arrzenhanced:sabri_leggings', 1, entity.persistentData['thorArmor'].leggings))
                        entity.setItemSlot(4, Item.of('arrzenhanced:sabri_chestplate', 1, entity.persistentData['thorArmor'].chestplate))
                    }
                    var px = entity.getX();
                    var py = entity.getY();
                    var pz = entity.getZ();
                    // entity.getLevel().playSound(null, px, py, pz, "arrzenhanced:armormanifest", "master", 0.25, 1)
                    KJSUtils.staticServer.runCommandSilent(`playsound arrzenhanced:armormanifest master @a ${px} ${py} ${pz}`)
                    KJSUtils.staticServer.runCommandSilent(`stopsound @a * minecraft:entity.lightning_bolt.impact`)
                    KJSUtils.staticServer.runCommandSilent(`stopsound @a * minecraft:entity.lightning_bolt.thunder`)
                    
                    entity.tags.add('Arrz.HasStormbreaker')
                }
            } else {
                var inventory = entity.getInventory()
                if (
                    entity.mainHandItem.is(Item.of('arrzenhanced:stormbreaker')) && // hand
                    inventory.getArmor(0) == 'arrzenhanced:sabri_boots' && // boot
                    inventory.getArmor(1) == 'arrzenhanced:sabri_leggings' && // leg
                    inventory.getArmor(2) == 'arrzenhanced:sabri_chestplate' // chest
                ) {
                    entity.persistentData['stormbreakerNBT'] = entity.mainHandItem.nbt
                    entity.persistentData['stormbreakerNBT'].Damage = 0
                    entity.persistentData['thorArmor'] = {}
                    entity.persistentData['thorArmor'].chestplate = inventory.getArmor(2).nbt
                    entity.persistentData['thorArmor'].chestplate.Damage = 0
                    entity.persistentData['thorArmor'].leggings = inventory.getArmor(1).nbt
                    entity.persistentData['thorArmor'].leggings.Damage = 0
                    entity.persistentData['thorArmor'].boots = inventory.getArmor(0).nbt
                    entity.persistentData['thorArmor'].boots.Damage = 0
                    entity.setMainHandItem(Item.of('minecraft:air'))
                    entity.setItemSlot(2, Item.of('minecraft:air'))
                    entity.setItemSlot(3, Item.of('minecraft:air'))
                    entity.setItemSlot(4, Item.of('minecraft:air'))

                    entity.tags.remove('Arrz.HasStormbreaker')
                } else {
                    Utils.server.runCommandSilent(`title ${entity.name.getString()} actionbar "You must wield your gifts to yield them."`)
                }
            }
        }
    })
    .lastTick((entity, entry, holder, enabled) => {
        if (enabled) {
            return
        }
    })
});