/*
    @author Hertz
    @version 1.0
*/

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('hertz:bifrost')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .firstTick((entity, entry, holder, enabled) => {
        if (enabled) {
            var level = entity.getLevel()
            var px = entity.getX();
            var py = entity.getY();
            var pz = entity.getZ();
            // level.playSound(null, px, py, pz, "arrzenhanced:bifrostactivate", "master", 1, 1)
            KJSUtils.staticServer.runCommandSilent(`playsound arrzenhanced:bifrostactivate master @a ${px} ${py} ${pz}`)
            // level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), "hertz_heroes:stop_it", "players", 100, 1)
        }
    })
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            var level = entity.getLevel()
            var px = entity.getX();
            var py = entity.getY();
            var pz = entity.getZ();

            level.spawnParticles("arrzenhanced:bifrost_spark", true, px, py+1, pz, 1, 10, 1, 150, 0);
            

            // bifrost dest
            var bifrost_dim = palladium.getProperty(entity, 'bifrost_dim')
            var bifrostDestLevel = entity.getServer().getLevel(bifrost_dim)
            var bx = palladium.getProperty(entity, 'bifrost_x')
            var by = palladium.getProperty(entity, 'bifrost_y')
            var bz = palladium.getProperty(entity, 'bifrost_z')

            bifrostDestLevel.spawnParticles("arrzenhanced:bifrost_spark", true, bx, by+1, bz, 1, 10, 1, 150, 0);
            // slow player here
        }
    })
    .lastTick((entity, entry, holder, enabled) => {
        if (enabled) {
            var px = entity.getX();
            var py = entity.getY();
            var pz = entity.getZ();

            var bifrost_x = palladium.getProperty(entity, 'bifrost_x')
            var bifrost_y = palladium.getProperty(entity, 'bifrost_y')
            var bifrost_z = palladium.getProperty(entity, 'bifrost_z')
            var bifrost_dim = palladium.getProperty(entity, 'bifrost_dim')

            if (!(bifrost_y < -64)) {
                let myBoundingBox = entity.getBoundingBox().inflate(2)
                entity.getLevel().getEntitiesWithin(myBoundingBox).forEach(target => {
                    if (target == entity) return
                    let tx = px - target.getX();
                    let ty = py - target.getY();
                    let tz = pz - target.getZ();
                    target.teleportTo(bifrost_dim, bifrost_x + tx, bifrost_y + ty, bifrost_z + tz, 0, 0)
                })
                entity.teleportTo(bifrost_dim, bifrost_x, bifrost_y, bifrost_z, 0, 0)
                // entity.getLevel().playSound(null, bifrost_x, bifrost_y, bifrost_z, "arrzenhanced:bifrostsendoff", "master", 1, 1)
                KJSUtils.staticServer.runCommandSilent(`playsound arrzenhanced:bifrostsendoff master @a ${bifrost_x} ${bifrost_y} ${bifrost_z}`)
            } else {
                entity.tell('The Bifrost cannot take you there!')
            }
        }
    })
});