// @author Hertz
// @version 1.0

var $ResourceKey_ = Java.loadClass("net.minecraft.resources.ResourceKey");
var DAMAGE_TYPE_KEY = $ResourceKey_.createRegistryKey("damage_type");
var $Vec3 = Java.loadClass("net.minecraft.world.phys.Vec3");

function getDamageSourceBothSidesArmed(
    /** @type {Internal.Level}*/ level,
    /** @type {Internal.DamageType_}*/ damageType,
    /** @type {Internal.LivingEntity}*/ destEntity,
    /** @type {Internal.LivingEntity}*/ sourceEntity
    ) {
    var resourceKey = $ResourceKey_.create(DAMAGE_TYPE_KEY, Utils.id(damageType))
    var holder = level.registryAccess().registryOrThrow(DAMAGE_TYPE_KEY).getHolderOrThrow(resourceKey)
    var damagesourceholder = holder
    return new DamageSource(damagesourceholder, sourceEntity, destEntity)
}

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:armed_and_dangerous')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .firstTick((entity, entry, holder, enabled) => global.armed_firstTick(entity, entry, holder, enabled))
    .tick((entity, entry, holder, enabled) => global.armed_tick(entity, entry, holder, enabled))
    .lastTick((entity, entry, holder, enabled) => global.armed_lastTick(entity, entry, holder, enabled))

    event.create('arrzenhanced:launch_at_angle')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .firstTick((entity, entry, holder, enabled) => global.launch_firstTick(entity, entry, holder, enabled))
    .tick((entity, entry, holder, enabled) => global.launch_tick(entity, entry, holder, enabled))
    .lastTick((entity, entry, holder, enabled) => global.launch_lastTick(entity, entry, holder, enabled))

    event.create('arrzenhanced:landing_damage')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .firstTick((entity, entry, holder, enabled) => global.landing_firstTick(entity, entry, holder, enabled))
    .tick((entity, entry, holder, enabled) => global.landing_tick(entity, entry, holder, enabled))
    .lastTick((entity, entry, holder, enabled) => global.landing_lastTick(entity, entry, holder, enabled))
});

global.armed_firstTick = (entity, entry, holder, enabled) => {
    if (enabled) {
        let move = entity.getLookAngle().scale(0.2).reverse();
        entity.setDeltaMovement(move);
        entity.setDeltaMovement(new $Vec3(0.0, 2.3, 0.0));
        
        entity.getLevel().playSound(null, entity.getX(), entity.getY(), entity.getZ(), 'arrzenhanced:circuit.power_up', 'master', 1, 1)

        if (entity.isPlayer()) {
            entity.connection.send(new ClientboundSetEntityMotionPacket(entity));
            if (!entity?.potionEffects) return
            entity.potionEffects.add('minecraft:slow_falling', 3 * 20, 4, false, false)
        }
    }
}
global.armed_tick = (entity, entry, holder, enabled) => {
    /*
    if (enabled) {
        if (entity.type != 'minecraft:player') return;
        
        let level = entity.getLevel(),
        player = entity

        for (var i = 0; i <= 10; i+=1.2) {
            let lookAngle = player.getLookAngle().scale(1 + i);
            let playerLocation = Vec3d(player.getX(), player.getY(), player.getZ());
            let particleTarget = Vec3d(
                playerLocation.x() + lookAngle.x(),
                playerLocation.y() + lookAngle.y(),
                playerLocation.z() + lookAngle.z()
            );

            player.getLevel().spawnParticles('arrzenhanced:clap', true, particleTarget.x(), particleTarget.y() + 1.15, particleTarget.z(), 0, 0, 0, 1, 0);
        }

        var pos = player.getEyePosition(); // Player's current position
        var look = player.getLookAngle(); // Player's look vector (direction they are looking)
        var start = pos.add(look.scale(0.5)); // Offset for the start of the AABB (0.5 blocks in front of the player)
        var end = pos.add(look.scale(11.5)); // Offset for the end of the AABB (7 blocks away from the player)

        var aabb = AABB.of(start.x(), start.y(), start.z(), end.x(), end.y(), end.z());
        player.getLevel().getEntitiesWithin(aabb).forEach(target => {
            if (target !== player) {
                let dx = target.getX() - player.getX()
                let dy = target.getY() - player.getY()
                let dz = target.getZ() - player.getZ()
                // let dist = Math.sqrt((dx * dx) + (dy * dy) + (dz * dz))
                let dist = 2

                let knockbackStrength = 2.5
                let vx = (dx / dist) * knockbackStrength
                let vy = (dy / dist) * knockbackStrength
                let vz = (dz / dist) * knockbackStrength
                target.setMotion(vx, vy, vz)
                if (target.isPlayer()) {
                    target.connection.send(new ClientboundSetEntityMotionPacket(target));
                }
                let damageSource = getDamageSourceBothSides(level, "minecraft:thrown", player, target)
                target.attack(damageSource, 7)
            }
        })
        entity.swing("MAIN_HAND", true)
    }
    */
}
global.armed_lastTick = (entity, entry, holder, enabled) => {
    if (enabled) {
        entity.tags.add('Arrz.Circuit.Launch')
    }
}

global.launch_firstTick = (entity, entry, holder, enabled) => {
    if (enabled) {
        // entity.tags.add('Arrz.Circuit.Launch')
        let move = entity.getLookAngle().scale(4);
        entity.setDeltaMovement(move);
    
        if (entity.isPlayer()) {
            entity.connection.send(new ClientboundSetEntityMotionPacket(entity));
        }
        entity.tags.remove('Arrz.Circuit.Launch')
        entity.tags.add('Arrz.Circuit.Landing')
    }
}
global.launch_tick = (entity, entry, holder, enabled) => {
    // entity.tags.remove('Arrz.Circuit.Launch')
}
global.launch_lastTick = (entity, entry, holder, enabled) => {
    // entity.tags.remove('Arrz.Circuit.Launch')
}



global.landing_firstTick = (entity, entry, holder, enabled) => {
    if (enabled) {
        // entity.tags.remove('Arrz.Circuit.Launch')
        let player = entity
        var aabb = AABB.of(
            entity.getX() + 5,
            entity.getY() + 5,
            entity.getZ() + 5,
            entity.getX() - 5,
            entity.getY() - 2,
            entity.getZ() - 5,
        );
        player.getLevel().getEntitiesWithin(aabb).forEach(target => {
            if (target !== player) {
                let dx = target.getX() - player.getX()
                let dy = target.getY() - player.getY()
                let dz = target.getZ() - player.getZ()
                // let dist = Math.sqrt((dx * dx) + (dy * dy) + (dz * dz))
                let dist = 2
    
                let knockbackStrength = 1.2
                let vx = (dx / dist) * knockbackStrength
                let vy = (dy / dist) * knockbackStrength
                let vz = (dz / dist) * knockbackStrength
                target.setMotion(vx, vy, vz)
                if (target.isPlayer()) {
                    target.connection.send(new ClientboundSetEntityMotionPacket(target));
                }
                let damageSource = getDamageSourceBothSidesArmed(player.getLevel(), "minecraft:thrown", player, target)
                target.attack(damageSource, 7)
            }
        })
        entity.getLevel().playSound(null, entity.getX(), entity.getY(), entity.getZ(), 'minecraft:entity.generic.explode', 'master', 0.8, 1)
        entity.getLevel().spawnParticles('minecraft:explosion', true, entity.getX(), entity.getY()+0.25, entity.getZ(), 2, 1, 2, 8, 0);
    }
}

global.landing_tick = (entity, entry, holder, enabled) => {
    // entity.tags.remove('Arrz.Circuit.Launch')
}

global.landing_lastTick = (entity, entry, holder, enabled) => {
    if (enabled) {
        entity.tags.remove('Arrz.Circuit.Landing')
        entity.removeEffect('minecraft:slow_falling')
    }
}
