// @author Hertz
// @version 1.0

let $Vec3 = Java.loadClass("net.minecraft.world.phys.Vec3");
let $ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:high_jump')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .firstTick((entity, entry, holder, enabled) => {
        if (enabled) {
            entity.setDeltaMovement(new $Vec3(0.0, 2.3, 0.0));
            if (entity.isPlayer()) {
                entity.connection.send(new $ClientboundSetEntityMotionPacket(entity));
                if (!entity?.potionEffects) return
                entity.potionEffects.add('minecraft:slow_falling', 3 * 20, 4, false, false)
            }
        }
    })
    .tick((entity, entry, holder, enabled) => {})
});