/*
    @author Hertz
    @version 1.0
*/

var $SuperpowerUtil = Java.loadClass('net.threetag.palladium.power.SuperpowerUtil')
var $ResourceLocation = Java.loadClass('net.minecraft.resources.ResourceLocation');
var $CuriosTrinketsUtil = Java.loadClass('net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil');

function resolveAllegedBooleanFromObject(thing) {
    if (thing.toString() == 'true') { return true; }
    if (thing.toString() == 'false') { return false; }
    return null
}

StartupEvents.registry('palladium:abilities', (event) => {

    event.create('arrzenhanced:suppress_powers')
    .icon(palladium.createItemIcon('minecraft:piston'))
    .addProperty('distance', 'integer', 10, 'Raycast distance')
    .firstTick((entity, entry, holder, enabled) => global.cord_ft(entity, entry, holder, enabled))
    .tick((entity, entry, holder, enabled) => global.cord_t(entity, entry, holder, enabled))
    .lastTick((entity, entry, holder, enabled) => global.cord_lt(entity, entry, holder, enabled))

    event.create('arrzenhanced:condense_suit')
    .icon(palladium.createItemIcon('minecraft:piston'))
    .tick((entity, entry, holder, enabled) => global.condense_suit(entity, entry, holder, enabled))

    event.create('arrzenhanced:expand_suit')
    .icon(palladium.createItemIcon('minecraft:piston'))
    .tick((entity, entry, holder, enabled) => global.expand_suit(entity, entry, holder, enabled))

});

global.condense_suit = (entity, entry, holder, enabled) => {
    if (enabled) {
        let boots = entity.getInventory().getArmor(0),
        legs = entity.getInventory().getArmor(1),
        chest = entity.getInventory().getArmor(2),
        helmet = entity.getInventory().getArmor(3)

        let nbt_data = {
            "storedArmor": {
                "boots": boots.getNbt(),
                "legs": legs.getNbt(),
                "chest": chest.getNbt(),
                "helmet": helmet.getNbt()
            }
        }

        var stored_suit = Item.of('arrzenhanced:essentium_bracelet', 1, NBT.toTagCompound(nbt_data))
        var storedSafely = false

        var allBracelets = $CuriosTrinketsUtil.getInstance().getSlot(entity, "bracelet")
        for (let i = 0; i < allBracelets.getSlots(); i++) {
            let currentSlot = allBracelets.getStackInSlot(i)
            if (currentSlot.isEmpty()) {
                allBracelets.setStackInSlot(i, stored_suit)
                storedSafely = true
            }
        }

        if (!storedSafely) {
            entity.give(stored_suit)
        }

        if (!entity.persistentData.cordaxe_armor_storage) {
            entity.persistentData.cordaxe_armor_storage = {}
            entity.persistentData.cordaxe_armor_storage['boots'] = Item.of("minecraft:air")
            entity.persistentData.cordaxe_armor_storage['legs'] = Item.of("minecraft:air")
            entity.persistentData.cordaxe_armor_storage['chest'] = Item.of("minecraft:air")
            entity.persistentData.cordaxe_armor_storage['helmet'] = Item.of("minecraft:air")
        }

        let stored_boots = entity.persistentData.cordaxe_armor_storage['boots']
        let stored_legs = entity.persistentData.cordaxe_armor_storage['legs']
        let stored_chest = entity.persistentData.cordaxe_armor_storage['chest']
        let stored_helmet = entity.persistentData.cordaxe_armor_storage['helmet']

        entity.setItemSlot(2, Item.of(stored_boots.id, stored_boots.Count, stored_boots.tag))
        entity.setItemSlot(3, Item.of(stored_legs.id, stored_legs.Count, stored_legs.tag))
        entity.setItemSlot(4, Item.of(stored_chest.id, stored_chest.Count, stored_chest.tag))
        entity.setItemSlot(5, Item.of(stored_helmet.id, stored_helmet.Count, stored_helmet.tag))
        delete entity.persistentData.cordaxe_armor_storage

        palladium.superpowers.addSuperpower(entity, "arrzenhanced:cordaxe_xform")
    }
}

global.expand_suit = (entity, entry, holder, enabled) => {
    if (enabled) {
        let boots = entity.getInventory().getArmor(0),
        legs = entity.getInventory().getArmor(1),
        chest = entity.getInventory().getArmor(2),
        helmet = entity.getInventory().getArmor(3)

        if (!entity.persistentData.cordaxe_armor_storage) {
            entity.persistentData.cordaxe_armor_storage = {}
        }
        entity.persistentData.cordaxe_armor_storage['boots'] = boots
        entity.persistentData.cordaxe_armor_storage['legs'] = legs
        entity.persistentData.cordaxe_armor_storage['chest'] = chest
        entity.persistentData.cordaxe_armor_storage['helmet'] = helmet

        let items = $CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, 'bracelet')
        var handled = false

        var extracted_nbt = {
            boots: {},
            legs: {},
            chest: {},
            helmet: {},
        }

        for (let i = 0; i < items.length; i++) {
            let item = items[i]
            if (item.id == 'arrzenhanced:essentium_bracelet' && !handled) {
                let nbtData = item.getNbt()
                if (!nbtData) {
                    // extracted_nbt = {}
                } else {
                    if (!nbtData.storedArmor) {return}
                    if (nbtData.storedArmor.boots) { extracted_nbt.boots = nbtData.storedArmor.boots }
                    if (nbtData.storedArmor.legs) { extracted_nbt.legs = nbtData.storedArmor.legs }
                    if (nbtData.storedArmor.chest) { extracted_nbt.chest = nbtData.storedArmor.chest }
                    if (nbtData.storedArmor.helmet) { extracted_nbt.helmet = nbtData.storedArmor.helmet }
                }
                handled = true
                item.copyAndClear()
            }
        }

        entity.setItemSlot(2, Item.of('arrzenhanced:cordaxe_boots', 1, extracted_nbt.boots))
        entity.setItemSlot(3, Item.of('arrzenhanced:cordaxe_leggings', 1, extracted_nbt.legs))
        entity.setItemSlot(4, Item.of('arrzenhanced:cordaxe_chestplate', 1, extracted_nbt.chest))
        entity.setItemSlot(5, Item.of('arrzenhanced:cordaxe_helmet', 1, extracted_nbt.helmet))

        palladium.superpowers.addSuperpower(entity, "arrzenhanced:cordaxe_xform")
    }
}

global.cord_ft = (entity, entry, holder, enabled) => {
    if (enabled) {
        let targetPowers = palladium.powers.getPowerIds(entity).toArray()
        let targetSuperpowers = []
        targetPowers.forEach((power) => {
            let hasPower = palladium.superpowers.hasSuperpower(entity, power)
            if (hasPower) {targetSuperpowers.push(power.toString())}
        })

        if (!entity.persistentData.cordaxe_power_storage) {
            // entity.persistentData.cordaxe_power_storage = {}
            entity.persistentData.cordaxe_power_storage = []
        }
        
        let whitelistedPowers = [
            'arrzenhanced:chaos_magic',
            'arrzenhanced:wrath_entity',
            'arrzenhanced:cordaxe_xform'
        ]
        let powersToReapply = []
        whitelistedPowers.forEach(wlPower => {
            if (palladium.superpowers.hasSuperpower(entity, wlPower)) {
                powersToReapply.push(wlPower)
            }
        });
        entity.persistentData.cordaxe_power_storage = JSON.stringify(targetSuperpowers)

        palladium.superpowers.removeAllSuperpowers(entity)

        powersToReapply.forEach(power => {
            palladium.superpowers.addSuperpower(entity, power)
        })
    }
}

global.cord_t = (entity, entry, holder, enabled) => {
    if (enabled) {
        return
        let basePowers = palladium.powers.getPowerIds(entity).toArray()
        let baseSuperpowers = []
        let baseSuperpowersLocations = []
        // entity.tell(basePowers)
        basePowers.forEach((power) => {
            let hasPower = palladium.superpowers.hasSuperpower(entity, power)
            if (hasPower) {baseSuperpowers.push(power.toString()); baseSuperpowersLocations.push(new $ResourceLocation(power.toString()))}
        })
        // entity.tell(baseSuperpowers)
        if (!entity.persistentData.code_transform) {
            entity.persistentData.code_transform = {}
            entity.persistentData.code_transform.active = 1
            entity.persistentData.code_transform.scannedPowers = []
            entity.persistentData.code_transform.power1 = []
            entity.persistentData.code_transform.power2 = []
            entity.persistentData.code_transform.power3 = []
        }
        // delete entity.persistentData.code_transform.baseSuperpowers;
        if (!entity.persistentData.code_transform.baseSuperpowers) {
            entity.persistentData.code_transform.baseSuperpowers = JSON.stringify(baseSuperpowers)
        }
        try {
            let scannedPowers = JSON.parse(entity.persistentData.code_transform.scannedPowers)
            let scanLoc = []
            // entity.tell(scannedPowers)
            scannedPowers.forEach((power) => {
                scanLoc.push(new $ResourceLocation(power))
            })
            $SuperpowerUtil['setSuperpowerIds(net.minecraft.world.entity.LivingEntity,java.util.List)'](entity, scanLoc);
            // palladium.superpowers.setSuperpowerIds(entity, entity.persistentData.code_transform.baseSuperpowers)
            // entity.tell(entity.persistentData.code_transform.scannedPowers)
        } catch (err) {
            entity.tell(err)
            console.log(err)
        }
    }
}

global.cord_lt = (entity, entry, holder, enabled) => {
    if (enabled) {
        if (!entity.persistentData.cordaxe_power_storage) {
            entity.persistentData.cordaxe_power_storage = []
        }
        if (entity.persistentData.cordaxe_power_storage) {
            let base = JSON.parse(entity.persistentData.cordaxe_power_storage)
            palladium.superpowers.removeAllSuperpowers(entity)
            let baseLoc = []
            base.forEach((power) => {
                baseLoc.push(new $ResourceLocation(power))
            })
            $SuperpowerUtil['setSuperpowerIds(net.minecraft.world.entity.LivingEntity,java.util.List)'](entity, baseLoc);
            delete entity.persistentData.cordaxe_power_storage
        }
    }
}