/*
    @author Hertz
    @version 1.0
*/

function resolveAllegedBooleanFromObject(thing) {
    if (thing.toString() == 'true') { return true; }
    if (thing.toString() == 'false') { return false; }
    return null
}

StartupEvents.registry('palladium:abilities', (event) => {
	event.create('hertz:collision_damage')
	.icon(palladium.createItemIcon('minecraft:netherite_boots'))
	.addProperty('damage', 'float', 20, 'Damage dealt to entities colliding with power-haver')
	.addProperty('kill', 'boolean', false, 'Kill the colliding entity?')
	.tick((entity, entry, holder, enabled) => {
		if (enabled) {
			var damage = entry.getPropertyByName('damage');
			var kill = resolveAllegedBooleanFromObject(entry.getPropertyByName('kill'));
			
			let bb = entity.boundingBox
            entity.getLevel().getEntitiesWithin(bb).forEach(target => {
                if (target == entity) return
                target.attack(damage)
                if (kill) {
                    target.kill()
                }
            })
		}
	});
});