/*
    @author Hertz
    @version 1.0
*/

const Mth = Java.loadClass('net.minecraft.util.Mth')
let EnergyBarReference = Java.loadClass('net.threetag.palladium.power.energybar.EnergyBarReference');
let STARLIGHT_ENERGY_REF = new EnergyBarReference('hertz_heroes:starlight', 'energy');

StartupEvents.registry('palladium:abilities', (event) => {

    event.create('hertz:concussive_blast')
    .icon(palladium.createItemIcon('minecraft:skeleton_skull'))
    .addProperty('particle', 'string', 'hertz_heroes:circle', 'Particle to spawn')
    .addProperty('distance', 'integer', 5, 'Distance of blast')
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            var distance = entry.getPropertyByName('distance');
            var particle = entry.getPropertyByName('particle');
            var energyBar = STARLIGHT_ENERGY_REF.getEntry(entity);

            var x = entity.getX();
            var y = entity.getY();
            var z = entity.getZ();
            var level = entity.getLevel()

            if ((energyBar.get() >= (energyBar.getMax()*0.80)) && entity.isCrouching()) { // over 80% energy, and crouching
                let player = entity;
                let level = player.getLevel()
                let count = 5000
                level.spawnParticles('minecraft:wax_off', true, x, y, z, 0, 0, 0, count, 100);
                energyBar.set(0)
                let myBoundingBox = player.getBoundingBox().inflate(distance)
                player.getLevel().getEntitiesWithin(myBoundingBox).forEach(target => {
                    if (target == player) return
                    target.attack(6)
                    target.potionEffects.add("minecraft:blindness", 7*20, 1, false, true)
                    target.potionEffects.add("minecraft:slowness", 8*20, 2, false, true)
                })
            } else {
                var theLevel = entity.getLevel()
                for (var i = 2; i <= distance; i++) {
                    let lookAngle = entity.getLookAngle().scale(i)
                    let playerLocation = Vec3d(
                        entity.getX(),
                        (entity.getY() + 1.62),
                        entity.getZ()
                    )
                    let targetLocation = Vec3d(
                        (playerLocation.x() + lookAngle.x()),
                        (playerLocation.y() + lookAngle.y()),
                        (playerLocation.z() + lookAngle.z())
                    )
                    theLevel.spawnParticles(particle, true, targetLocation.x(), targetLocation.y(), targetLocation.z(), 0, 0, 0, 1, 0);
                }
    
                let player = entity;
                let myBoundingBox = player.getBoundingBox().inflate(distance)
                player.getLevel().getEntitiesWithin(myBoundingBox).forEach(target => {
                    if (target == player) return
                    // math stuff here
                    let dx = player.getX() - target.getX()
                    let dz = player.getZ() - target.getZ()
                    let targetYaw = Mth.wrapDegrees(Math.atan2(dz, dx) * (180/JavaMath.PI) + 90)
                    targetYaw = targetYaw % 360
                    if (targetYaw < 0) targetYaw += 360
                    // player.tell(`Target Yaw: ${targetYaw}`);
    
                    let playerYaw = player.getYaw() % 360
                    if (playerYaw < 0) playerYaw += 360
                    // player.tell(`Player Yaw: ${playerYaw}`);
    
                    let minYaw = (playerYaw - 15) % 360
                    if (minYaw < 0) minYaw += 360
                    let maxYaw = (playerYaw + 15) % 360
                    if (maxYaw < 0) maxYaw += 360
                    // player.tell(`Min Yaw: ${minYaw}, Max Yaw: ${maxYaw}`);
                    let isWithinRange
                    if (minYaw < maxYaw) {
                        isWithinRange = (targetYaw >= minYaw && targetYaw <= maxYaw)
                    } else  {
                        isWithinRange = (targetYaw >= minYaw || targetYaw <= maxYaw)
                    }
                    // player.tell(`Is Within Range: ${isWithinRange}`);
                    if (isWithinRange) {
                        target.attack(4)
                        target.potionEffects.add("minecraft:blindness", 4*20, 1, false, true)
                        target.potionEffects.add("minecraft:slowness", 2*20, 2, false, true)
                    }
                })
            }
        };
    });
});