/*
    @author Hertz
    @version 1.0
*/

let EnergyBarReference = Java.loadClass('net.threetag.palladium.power.energybar.EnergyBarReference');
const GREED_ENERGY_REF = new EnergyBarReference('arrzenhanced:orange_lantern', 'greed');

StartupEvents.registry('palladium:abilities', (event) => {

    event.create('hertz:greed_loop')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .tick((entity, entry, holder, enabled) => {
        if (entity.type != "minecraft:player") {return}
        var playerPowerBar = GREED_ENERGY_REF.getEntry(entity)
        if (playerPowerBar.get() == playerPowerBar.getMax()) return;
        if (enabled) {
            var inventory = entity.getInventory()
            var numSlots = inventory.getSlots()
            var hasLow, hasMedium, hasHigh, hasUltra;
            for (var i = 0; i < numSlots; i++) {
                // get item
                let item = inventory.getStackInSlot(i)
                // Check if the slot is not empty
                if (!item.isEmpty()) {
                    if (item.hasTag('hertz:low_value') && !hasLow) {
                        playerPowerBar.add(10)
                        hasLow = true
                    } else if (item.hasTag('hertz:medium_value') && !hasMedium) {
                        playerPowerBar.add(20)
                        hasMedium = true
                    } else if (item.hasTag('hertz:high_value') && !hasHigh) {
                        playerPowerBar.add(40)
                        hasHigh = true
                    } else if (item.hasTag('hertz:ultra_value') && !hasUltra) {
                        playerPowerBar.add(80)
                        hasUltra = true
                    }
                }
            }
        }
    })
});
