var $CuriosTrinketsUtil = Java.loadClass('net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil')

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:break_curios')
    .icon(palladium.createItemIcon('minecraft:iron_nugget'))
    .firstTick((entity, entry, holder, enabled) => global.break_curiosFT(entity, entry, holder, enabled))
    .tick((entity, entry, holder, enabled) => global.break_curiosT(entity, entry, holder, enabled))
    .lastTick((entity, entry, holder, enabled) => global.break_curiosLT(entity, entry, holder, enabled));
});

global.break_curiosFT = (entity, entry, holder, enabled) => {
    if (enabled) {
        return
    }
}
global.break_curiosT = (entity, entry, holder, enabled) => {
    if (enabled) {
        if (entity.age % 5 === 0) {
            entity.getLevel().playSound(null, entity.getX(), entity.getY(), entity.getZ(), 'minecraft:item.shield.break', 'players', 0.5, 2);
        }
        if (entity.age % 8 === 0) {
            entity.getLevel().playSound(null, entity.getX(), entity.getY(), entity.getZ(), 'minecraft:item.shield.break', 'players', 0.5, 2);
        }
    }
}
global.break_curiosLT = (entity, entry, holder, enabled) => {
    if (enabled) {
        let allCurios = [
            $CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, Platform.isForge() ? 'bracelet' : 'hand/glove'),
            $CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, Platform.isForge() ? 'necklace' : 'chest/necklace'),
            $CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, Platform.isForge() ? 'back' : 'chest/back'),
            $CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, Platform.isForge() ? 'belt' : 'legs/belt'),
            $CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, Platform.isForge() ? 'body' : 'head/face'),
            $CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, Platform.isForge() ? 'charm' : 'chest/cape'),
            $CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, Platform.isForge() ? 'head' : 'head/hat'),
            $CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, Platform.isForge() ? 'hands' : 'hand/glove'),
            $CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, Platform.isForge() ? 'ring' : 'hand/glove')
        ];

        allCurios.forEach((upperLayer) => {
            upperLayer.forEach((item) => {
                if (item.hasTag('dampened:handcuffs')) {
                    item.setCount(0);

                    entity.getLevel().playSound(null, entity.getX(), entity.getY(), entity.getZ(), 'minecraft:entity.item.break', 'players', 0.5, 1);
                    let lookAngle = entity.getLookAngle().scale(1)
                    let playerLocation = Vec3d(
                        entity.getX(),
                        (entity.getY() + 1),
                        entity.getZ()
                    )
                    let targetLocation = Vec3d(
                        (playerLocation.x() + lookAngle.x()),
                        (playerLocation.y() + lookAngle.y()),
                        (playerLocation.z() + lookAngle.z())
                    )
                    let particle = Utils.particleOptions('item netherite_block')
                    entity.getLevel().spawnParticles(particle, true, targetLocation.x(), targetLocation.y(), targetLocation.z(), 0.1, 0.1, 0.1, 5, 0);
                }
                else if (item.id.match('dampened')) {
                    item.setCount(0);
                }
            });
        });
    }
}
