/*
    @author Hertz
    @version 1.0
*/

var ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');
var EnergyBarReference = Java.loadClass('net.threetag.palladium.power.energybar.EnergyBarReference');
var IMPASSE_KINETIC_REF = new EnergyBarReference('arrzenhanced:impasse', 'kinetic');

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:kinetic_accumulation')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            if (entity.type != 'minecraft:player') return;
            var playerPowerBar = IMPASSE_KINETIC_REF.getEntry(entity)
            if (playerPowerBar.get() == 0) return;
            let ratio = 1.20 / playerPowerBar.getMax()
            let currentSpeed = ratio * playerPowerBar.get()

            let yawRadians = (entity.yaw + 90) * (JavaMath.PI / 180);
            let motionX = Math.cos(yawRadians);
            let motionZ = Math.sin(yawRadians);
            entity.setMotion(motionX * currentSpeed, entity.motionY, motionZ * currentSpeed);

            if (entity.type === 'minecraft:player') {
                entity.connection.send(new ClientboundSetEntityMotionPacket(entity));
            }
        }
    })
});