// arrzenhanced:scaling_strength
// @author Hertz
// @version 1.0

var EnergyBarReference = Java.loadClass('net.threetag.palladium.power.energybar.EnergyBarReference');
var IMPASSE_KINETIC_REF = new EnergyBarReference('arrzenhanced:impasse', 'kinetic');
var HYPERIOR_RAGE_REF = new EnergyBarReference('arrzenhanced:hyperior', 'rage');

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:scaling_strength')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            if (entity.type != 'minecraft:player') return;

            var playerPowerBar = false
            let ratio = 0
            if (palladium.superpowers.hasSuperpower(entity, 'arrzenhanced:hyperior')) {
                playerPowerBar = HYPERIOR_RAGE_REF.getEntry(entity)
                ratio = 5 / playerPowerBar.getMax()
            } else if (palladium.superpowers.hasSuperpower(entity, 'arrzenhanced:impasse')) {
                playerPowerBar = IMPASSE_KINETIC_REF.getEntry(entity)
                ratio = 4 / playerPowerBar.getMax()
            } else {
                return;
            }
            if (playerPowerBar.get() == 0) return;

            let currentStrength = Math.round(ratio * playerPowerBar.get())
            entity.modifyAttribute("minecraft:generic.attack_damage", "0e26b821-2df2-4877-8cba-624ce9b8f57d", currentStrength, "ADDITION")
            entity.modifyAttribute("minecraft:generic.knockback_resistance", "4896b26e-e39b-4b6e-8c57-0d79ca9c4c6a", 200, "ADDITION")
        }
    })
    .lastTick((entity, entry, holder, enabled) => {
        if (enabled) {
            if (entity.type != 'minecraft:player') return;

            entity.removeAttribute("minecraft:generic.attack_damage", "0e26b821-2df2-4877-8cba-624ce9b8f57d")
            entity.removeAttribute("minecraft:generic.knockback_resistance", "4896b26e-e39b-4b6e-8c57-0d79ca9c4c6a")
        }
    });
});
