// arrzenhanced:unstoppable
// @author Hertz
// @version 1.0

var EnergyBarReference = Java.loadClass('net.threetag.palladium.power.energybar.EnergyBarReference');
var IMPASSE_KINETIC_REF = new EnergyBarReference('arrzenhanced:impasse', 'kinetic');

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:unstoppable')
    .icon(palladium.createItemIcon('minecraft:netherite_ingot'))
    .tick((entity, entry, holder, enabled) => global.unstoppable(entity, entry, holder, enabled))
});

global.unstoppable = (entity, entry, holder, enabled) => {
    if (enabled) {
        if (entity.type != 'minecraft:player') return;
        var player = entity;
        var world = player.getLevel();
        var facing = player.getFacing();

        // Determine the offset based on the player's facing direction
        var offsetX = 0, offsetY = 0, offsetZ = 0;
        switch (facing) {
            case 'north':
                offsetZ = -1;
                break;
            case 'south':
                offsetZ = 1;
                break;
            case 'east':
                offsetX = 1;
                break;
            case 'west':
                offsetX = -1;
                break;
            case 'up':
                offsetY = 1;
                break;
            case 'down':
                offsetY = -1;
                break;
        }
        // player.tell('FACING: ' + facing.toString())

        // Get the block at the player's current position in the facing direction
        var blockPos1 = new BlockPos(
            Math.floor(player.getX() + offsetX),
            Math.floor(player.getY() + offsetY),
            Math.floor(player.getZ() + offsetZ)
        );

        // Get the block one block above the player's current position in the facing direction
        var blockPos2 = new BlockPos(
            Math.floor(player.getX() + offsetX),
            Math.floor(player.getY() + offsetY + 1),
            Math.floor(player.getZ() + offsetZ)
        );

        // Retrieve and print the block IDs
        var blockState1 = world.getBlockState(blockPos1);
        var blockId1 = blockState1.getBlock().id;

        var blockState2 = world.getBlockState(blockPos2);
        var blockId2 = blockState2.getBlock().id;


        // entity.tell(blockState1.getBlock().explosionResistance)
        // entity.tell(blockState2.getBlock().explosionResistance)

        var blacklist = [
            'minecraft:chest',
            'minecraft:trapped_chest',
            'minecraft:ender_chest',
            'minecraft:barrel',
            'minecraft:shulker_box',
            'minecraft:furnace',
            'minecraft:blast_furnace',
            'minecraft:smoker',
            'minecraft:campfire',
            'minecraft:soul_campfire',
            'minecraft:beacon',
            'minecraft:bell',
            'minecraft:conduit',
            'minecraft:enchanting_table',
            'minecraft:end_portal_frame',
            'minecraft:end_gateway',
            'minecraft:air',
            'minecraft:water',
            'minecraft:lava',
            'minecraft:cave_air',
            'minecraft:void_air',
            'minecraft:structure_void',
            'minecraft:structure_block',
            'minecraft:structure_void',
        ]

        if (blockState1.getBlock().explosionResistance < 12.0 && !blacklist.includes(blockId1)) {
            world.destroyBlock(blockPos1, true, null, 32)
            
            var playerPowerBar = IMPASSE_KINETIC_REF.getEntry(entity)
            playerPowerBar.set(playerPowerBar.get() - 10);
        }
        if (blockState2.getBlock().explosionResistance < 12.0 && !blacklist.includes(blockId2)) {
            world.destroyBlock(blockPos2, true, null, 32)
            
            var playerPowerBar = IMPASSE_KINETIC_REF.getEntry(entity)
            playerPowerBar.set(playerPowerBar.get() - 10);
        }
    }
}
