/*
    @author Hertz
    @version 1.0
*/

let ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');
let $ResourceLocation = Java.loadClass('net.minecraft.resources.ResourceLocation');
let $ResourceKey = Java.loadClass("net.minecraft.resources.ResourceKey")
let DAMAGE_TYPE = $ResourceKey.createRegistryKey("damage_type")

let $ClipContext = Java.loadClass('net.minecraft.world.level.ClipContext')
let $ProjectileUtil = Java.loadClass('net.minecraft.world.entity.projectile.ProjectileUtil')

function getDamageSourceBothSides(
    /** @type {Internal.Level}*/ level,
    /** @type {Internal.DamageType_}*/ damageType,
    /** @type {Internal.LivingEntity}*/ destEntity,
    /** @type {Internal.LivingEntity}*/ sourceEntity
    ) {
    var resourceKey = $ResourceKey.create(DAMAGE_TYPE, Utils.id(damageType))
    var holder = level.registryAccess().registryOrThrow(DAMAGE_TYPE).getHolderOrThrow(resourceKey)
    var damagesourceholder = holder
    return new DamageSource(damagesourceholder, sourceEntity, destEntity)
}

StartupEvents.registry('palladium:abilities', (event) => {
    
    event.create('arrzenhanced:arrow_select')
    .icon(palladium.createItemIcon('minecraft:feather'))
    .addProperty('operation', 'string', 'next', 'next / back / reset')
    .tick((entity, entry, holder, enabled) => {
        var selCd = palladium.getProperty(entity, 'arrzenhanced.iron_prism.selection_cooldown')
        if (selCd > 0) {palladium.setProperty(entity, 'arrzenhanced.iron_prism.selection_cooldown', selCd-1)}

        if (enabled) {
            var arrowMappings = {
                "0": "arrzenhanced:trick_arrow_base",
                "1": "arrzenhanced:explosive_arrow",
                "2": "arrzenhanced:healing_arrow",
                "3": "arrzenhanced:diamond_arrow",
                "4": "arrzenhanced:ender_pearl_arrow",
                "5": "arrzenhanced:knockback_arrow",
                "6": "arrzenhanced:dampening_arrow",
                "7": "arrzenhanced:essentium_arrow",
            }
            var operation = entry.getPropertyByName('operation')
            // arrzenhanced.iron_prism.arrow_sel : 0
            var currentSelect = palladium.getProperty(entity, 'arrzenhanced.iron_prism.arrow_sel')
            if (operation == 'next') {currentSelect += 1}
            else if (operation == 'back') {currentSelect -= 1}
            else if (operation == 'reset') {currentSelect = 0}

            if (currentSelect <= -1) { currentSelect = Object.keys(arrowMappings).length-1 } // rollunder
            if (currentSelect >= Object.keys(arrowMappings).length) { currentSelect = 0 } // rollover

            if (arrowMappings[currentSelect.toString()] == undefined) {return}
            // entity.tell(`Selecting: ${arrowMappings[currentSelect.toString()]}`)

            palladium.setProperty(entity, 'arrzenhanced.iron_prism.selection_cooldown',6 * 20)
            palladium.setProperty(entity, 'arrzenhanced.iron_prism.arrow_sel', currentSelect)
            // playsound minecraft:ui.button.click players @s ~ ~ ~ 1 1
            entity.getServer().runCommandSilent(`execute as ${entity.getGameProfile().getName()} at ${entity.getGameProfile().getName()} run playsound minecraft:ui.button.click player ${entity.getGameProfile().getName()} ~ ~ ~ 1 1.5`)
            // entity.getLevel().playSound(entity, entity.getX(), entity.getY(), entity.getZ(), 'minecraft:ui.button.click', 'players', 1, 1)
        };
    });
    
    event.create('arrzenhanced:fire_selected_arrow')
    .icon(palladium.createItemIcon('minecraft:arrow'))
    .tick((entity, entry, holder, enabled) => global.iron_prism_fire_arrow(entity, entry, holder, enabled));
    
    event.create('arrzenhanced:load_arrow')
    .icon(palladium.createItemIcon('minecraft:arrow'))
    .addProperty('operation', 'string', 'load', 'load / unload')
    .tick((entity, entry, holder, enabled) => global.iron_prism_load_arrow(entity, entry, holder, enabled));
    
    event.create('arrzenhanced:discarded_arrow')
    .icon(palladium.createItemIcon('minecraft:arrow'))
    .tick((entity, entry, holder, enabled) => global.iron_prism_arrow_down(entity, entry, holder, enabled));
});

global.iron_prism_fire_arrow = (entity, entry, holder, enabled) => {
    if (enabled) {
        var arrowMappings = {
            "0": "arrzenhanced:trick_arrow_base",
            "1": "arrzenhanced:explosive_arrow",
            "2": "arrzenhanced:healing_arrow",
            "3": "arrzenhanced:diamond_arrow",
            "4": "arrzenhanced:ender_pearl_arrow",
            "5": "arrzenhanced:knockback_arrow",
            "6": "arrzenhanced:dampening_arrow",
            "7": "arrzenhanced:essentium_arrow",
        }
        var chestplateNames = {
            "0": "base_count",
            "1": "explosive_count",
            "2": "healing_count",
            "3": "diamond_count",
            "4": "ender_pearl_count",
            "5": "knockback_count",
            "6": "dampening_count",
            "7": "essentium_count",
        }
        var arrowData = {
            "0": {
                "Damage": 4,
                "Gravity": 0.04,
                "Size": 0.5,
                "Lifetime": 200,
                "Tags": ["arrz.trick_arrow", 'arrz.trick_arrow.base', `arrz.owner.${entity.getGameProfile().getName()}`],
                "DieOnEntityHit": true,
                "DieOnBlockHit": true,
                "CommandOnEntityHit": "function arrzenhanced:iron_prism/trick_arrows/summon_base_arrow",
                "CommandOnBlockHit": "function arrzenhanced:iron_prism/trick_arrows/summon_base_arrow",
                "Appearances": [
                    {
                        "Type": "renderLayer",
                        "RenderLayer": "arrzenhanced:arrow/base"
                    }
                ]
            },
            "1": {
                "Damage": 0,
                "Gravity": 0.04,
                "Size": 0.5,
                "Lifetime": 200,
                "Tags": ["arrz.trick_arrow", 'arrz.trick_arrow.explosive', `arrz.owner.${entity.getGameProfile().getName()}`],
                "DieOnEntityHit": true,
                "DieOnBlockHit": true,
                "CommandOnEntityHit": "function arrzenhanced:iron_prism/trick_arrows/summon_explosive_arrow",
                "CommandOnBlockHit": "function arrzenhanced:iron_prism/trick_arrows/summon_explosive_arrow",
                "Appearances": [
                    {
                        "Type": "renderLayer",
                        "RenderLayer": "arrzenhanced:arrow/explosive"
                    }
                ]
            },
            "2": {
                "Damage": 0,
                "Gravity": 0.04,
                "Size": 0.5,
                "Lifetime": 200,
                "Tags": ["arrz.trick_arrow", 'arrz.trick_arrow.healing', `arrz.owner.${entity.getGameProfile().getName()}`],
                "DieOnEntityHit": true,
                "DieOnBlockHit": true,
                "CommandOnEntityHit": "function arrzenhanced:iron_prism/trick_arrows/summon_healing_arrow",
                "CommandOnBlockHit": "function arrzenhanced:iron_prism/trick_arrows/summon_healing_arrow",
                "Appearances": [
                    {
                        "Type": "renderLayer",
                        "RenderLayer": "arrzenhanced:arrow/healing"
                    }
                ]
            },
            "3": {
				"Damage": 8,
				"Gravity": 0.04,
				"Size": 0.5,
				"Lifetime": 200,
				"Tags": ["arrz.trick_arrow", 'arrz.trick_arrow.diamond', `arrz.owner.${entity.getGameProfile().getName()}`],
				"DieOnEntityHit": true,
				"DieOnBlockHit": true,
				"CommandOnEntityHit": "function arrzenhanced:iron_prism/trick_arrows/summon_diamond_arrow",
				"CommandOnBlockHit": "function arrzenhanced:iron_prism/trick_arrows/summon_diamond_arrow",
				"Appearances": [
					{
						"Type": "renderLayer",
						"RenderLayer": "arrzenhanced:arrow/diamond"
					}
				]
			},
            "4": {
                "Damage": 0,
                "Gravity": 0.04,
                "Size": 0.5,
                "Lifetime": 200,
                "Tags": ["arrz.trick_arrow", 'arrz.trick_arrow.ender_pearl', `arrz.owner.${entity.getGameProfile().getName()}`],
                "DieOnEntityHit": true,
                "DieOnBlockHit": true,
                "CommandOnEntityHit": "function arrzenhanced:iron_prism/trick_arrows/summon_ender_pearl_arrow",
                "CommandOnBlockHit": "function arrzenhanced:iron_prism/trick_arrows/summon_ender_pearl_arrow",
                "Appearances": [
                    {
                        "Type": "renderLayer",
                        "RenderLayer": "arrzenhanced:arrow/ender_pearl"
                    }
                ]
            },
            "5": {
                "Damage": 3,
                "Gravity": 0.04,
                "Size": 0.5,
                "Lifetime": 200,
                "KnockbackStrength": 6,
                "Tags": ["arrz.trick_arrow", 'arrz.trick_arrow.knockback', `arrz.owner.${entity.getGameProfile().getName()}`],
                "DieOnEntityHit": true,
                "DieOnBlockHit": true,
                "CommandOnEntityHit": "function arrzenhanced:iron_prism/trick_arrows/summon_knockback_arrow",
                "CommandOnBlockHit": "function arrzenhanced:iron_prism/trick_arrows/summon_knockback_arrow",
                "Appearances": [
                    {
                        "Type": "renderLayer",
                        "RenderLayer": "arrzenhanced:arrow/knockback"
                    }
                ]
            },
            "6": {
                "Damage": 3,
                "Gravity": 0.04,
                "Size": 0.5,
                "Lifetime": 200,
                "Tags": ["arrz.trick_arrow", 'arrz.trick_arrow.dampening', `arrz.owner.${entity.getGameProfile().getName()}`],
                "DieOnEntityHit": true,
                "DieOnBlockHit": true,
                "CommandOnEntityHit": "function arrzenhanced:iron_prism/trick_arrows/summon_dampening_arrow",
                "CommandOnBlockHit": "function arrzenhanced:iron_prism/trick_arrows/summon_dampening_arrow",
                "Appearances": [
                    {
                        "Type": "renderLayer",
                        "RenderLayer": "arrzenhanced:arrow/dampening"
                    }
                ]
            },
            "7": {
                "Damage": 20,
                "Gravity": 0.04,
                "Size": 0.5,
                "Lifetime": 200,
                "Tags": ["arrz.trick_arrow", 'arrz.trick_arrow.essentium', `arrz.owner.${entity.getGameProfile().getName()}`],
                "DieOnEntityHit": true,
                "DieOnBlockHit": true,
                "CommandOnEntityHit": "function arrzenhanced:iron_prism/trick_arrows/summon_essentium_arrow",
                "CommandOnBlockHit": "function arrzenhanced:iron_prism/trick_arrows/summon_essentium_arrow",
                "Appearances": [
                    {
                        "Type": "renderLayer",
                        "RenderLayer": "arrzenhanced:arrow/essentium"
                    }
                ]
            }
        }
        // arrzenhanced.iron_prism.arrow_sel : 0
        var currentSelect = palladium.getProperty(entity, 'arrzenhanced.iron_prism.arrow_sel')
        if (arrowMappings[currentSelect.toString()] == undefined) {return}
        // entity.tell(`Firing: ${arrowMappings[currentSelect.toString()]}`)
        var inventory = entity.getInventory()
        let chestplate = inventory.getArmor(2)
        if (chestplate.isEmpty() || chestplate.id != 'arrzenhanced:iron_prism_chestplate') {return}
        let storedArrows = chestplate.nbt.getDouble(chestplateNames[currentSelect])
        if (storedArrows <= 0) {
            entity.getLevel().playSound(null, entity.getX(), entity.getY(), entity.getZ(), 'minecraft:block.dispenser.fail', 'master', 1, 1);
            return;
        }
        storedArrows -= 1
        chestplate.nbt.putDouble(chestplateNames[currentSelect], storedArrows)
        entity.getLevel().playSound(null, entity.getX(), entity.getY(), entity.getZ(), 'minecraft:block.dispenser.launch', 'master', 1, 1);

        try {
            let yawOffset = 15,
            pitchOffset = 25,
            frontOffset = 0,
            speed = 3

            var projectile = entity.block.createEntity('palladium:custom_projectile')
            projectile.mergeNbt(arrowData[currentSelect.toString()])

            var pitch = -toRadians(entity.getPitch() + pitchOffset);
            var yaw = -toRadians(entity.getYaw() + yawOffset);

            var x = entity.getX() + Math.cos(pitch) * Math.sin(yaw),
            y = entity.getY() + entity.getEyeHeight() + Math.sin(pitch),
            z = entity.getZ() + Math.cos(pitch) * Math.cos(yaw);

            if (frontOffset != -999) {
                x = entity.getX() + (Math.cos(pitch) * Math.sin(yaw)) + (frontOffset * Math.sin(yaw)),
                y = entity.getY() + entity.getEyeHeight() + Math.sin(pitch),
                z = entity.getZ() + (Math.cos(pitch) * Math.cos(yaw)) + (frontOffset * Math.cos(yaw));
            }
            
            projectile.setPos(x, y, z)
            projectile.setDeltaMovement(entity.getLookAngle().scale(speed))
            projectile.setRotation(-entity.getYaw(), -entity.getPitch())

            projectile.setOwner(entity)
            projectile.spawn()
        } catch (err) {
            entity.tell(err)
        }

        // palladium.setProperty(entity, 'arrzenhanced.iron_prism.arrow_sel', currentSelect)
    };
}

global.iron_prism_load_arrow = (entity, entry, holder, enabled) => {
    if (enabled) {
        var arrowMappings = {
            "0": "arrzenhanced:trick_arrow_base",
            "1": "arrzenhanced:explosive_arrow",
            "2": "arrzenhanced:healing_arrow",
            "3": "arrzenhanced:diamond_arrow",
            "4": "arrzenhanced:ender_pearl_arrow",
            "5": "arrzenhanced:knockback_arrow",
            "6": "arrzenhanced:dampening_arrow",
            "7": "arrzenhanced:essentium_arrow",
        }
        var chestplateNames = {
            "0": "base_count",
            "1": "explosive_count",
            "2": "healing_count",
            "3": "diamond_count",
            "4": "ender_pearl_count",
            "5": "knockback_count",
            "6": "dampening_count",
            "7": "essentium_count",
        }
        var operation = entry.getPropertyByName('operation')

        if (operation == "load") {
            var arrowIndex = Object.keys(arrowMappings).find(key => arrowMappings[key] === entity.getMainHandItem().id),
            hand = "main"
            if (arrowIndex == undefined) {arrowIndex = Object.keys(arrowMappings).find(key => arrowMappings[key] === entity.getOffHandItem().id); hand = "off"}
            if (arrowIndex == undefined) {return}

            var inventory = entity.getInventory()
            let chestplate = inventory.getArmor(2)
            if (chestplate.isEmpty() || chestplate.id != 'arrzenhanced:iron_prism_chestplate') {return}
            let storedArrows = chestplate.nbt.getDouble(chestplateNames[arrowIndex])
            if (storedArrows >= 32) {return}
            storedArrows += 1
            if (hand == "main") {entity.mainHandItem.count--}
            if (hand == "off") {entity.offHandItem.count--}
            chestplate.nbt.putDouble(chestplateNames[arrowIndex], storedArrows)
            // minecraft:item.armor.equip_iron
            entity.getLevel().playSound(null, entity.getX(), entity.getY(), entity.getZ(), 'minecraft:item.armor.equip_iron', 'master', 1, 1);
        }
        else if (operation == "unload") {
            var currentSelect = palladium.getProperty(entity, 'arrzenhanced.iron_prism.arrow_sel')
            if (arrowMappings[currentSelect.toString()] == undefined) {return}
            //
            var inventory = entity.getInventory()
            let chestplate = inventory.getArmor(2)
            if (chestplate.isEmpty() || chestplate.id != 'arrzenhanced:iron_prism_chestplate') {return}
            let storedArrows = chestplate.nbt.getDouble(chestplateNames[currentSelect])
            if (storedArrows <= 0) {return}
            storedArrows -= 1
            entity.give(Item.of(arrowMappings[currentSelect]))
            chestplate.nbt.putDouble(chestplateNames[currentSelect], storedArrows)
            // minecraft:item.armor.equip_generic
            entity.getLevel().playSound(null, entity.getX(), entity.getY(), entity.getZ(), 'minecraft:item.armor.equip_generic', 'master', 1, 1);
        }
    };
}

global.iron_prism_arrow_down = (entity, entry, holder, enabled) => {
    if (enabled) {
        var arrowMappings = {
            "0": "arrzenhanced:trick_arrow_base",
            "1": "arrzenhanced:explosive_arrow",
            "2": "arrzenhanced:healing_arrow",
            "3": "arrzenhanced:diamond_arrow",
            "4": "arrzenhanced:ender_pearl_arrow",
            "5": "arrzenhanced:knockback_arrow",
            "6": "arrzenhanced:dampening_arrow",
            "7": "arrzenhanced:essentium_arrow",
        }
        var arrowConversions = [
            "arrz.trick_arrow.base",
            "arrz.trick_arrow.explosive",
            "arrz.trick_arrow.healing",
            "arrz.trick_arrow.diamond",
            "arrz.trick_arrow.ender_pearl",
            "arrz.trick_arrow.knockback",
            "arrz.trick_arrow.dampening",
            "arrz.trick_arrow.essentium",
        ]

        // entity.getServer().runCommand(`say ${entity.age}`)
        if (entity.age > 1200) {entity.kill()}

        var owner = "None"
        entity.tags.toArray().forEach(tag => {
            if (tag.includes('arrz.owner')) {owner = tag.substring(11)}
        })
        // console.log(owner)

        /*
        if (
            entity.tags.contains('arrz.trick_arrow.dampening')
        ) {
            if (entity.age > 350) {
                entity.getLevel().playSound(null, entity.getX(), entity.getY(), entity.getZ(), 'minecraft:item.shield.break', 'master', 1, 1);
                entity.kill()
            }
            if (entity.age % 20 == 0) {entity.getLevel().spawnParticles("minecraft:firework", true, entity.getX(), entity.getY() + 1, entity.getZ(), 7, 7, 7, 50, 0)}
            var level = entity.getLevel()
            level.getEntitiesWithin(entity.getBoundingBox().inflate(7)).forEach(target => {
                if (
                    target == entity
                ) {
                    return;
                }

                if (!target?.potionEffects) return
                target.potionEffects.add('dampened:dark_matter', 2, 0, false, false)
                target.potionEffects.add('dampened:genetic', 2, 0, false, false)
                target.potionEffects.add('dampened:emp', 2, 0, false, false)
            })
        }
        */

        if (
            entity.tags.contains('arrz.trick_arrow.healing')
        ) {
            if (entity.age > 80) {
                entity.getLevel().playSound(null, entity.getX(), entity.getY(), entity.getZ(), 'minecraft:item.shield.break', 'master', 1, 1);
                entity.kill()
            }
            if (entity.age % 5 == 0) {entity.getLevel().spawnParticles("minecraft:heart", true, entity.getX(), entity.getY() + 0.2, entity.getZ(), 1, 0.05, 1, 25, 0)}
            var level = entity.getLevel()
            level.getEntitiesWithin(entity.getBoundingBox().inflate(2, 1, 2)).forEach(target => {
                if (
                    target == entity
                ) {
                    return;
                }

                if (!target?.potionEffects) return
                if (target.potionEffects.getDuration('minecraft:regeneration') <= 0) {
                    target.potionEffects.add('minecraft:regeneration', 2 * 20, 4, false, false)
                }
            })
        }

        if (
            entity.tags.contains('arrz.trick_arrow.explosive')
        ) {
            if (entity.age > 10) {entity.kill()}
            var level = entity.getLevel()
            level.spawnParticles("minecraft:explosion", true, entity.getX(), entity.getY() + 0.2, entity.getZ(), 1.5, 1.5, 1.5, 8, 0)
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), 'entity.generic.explode', 'master', 1, 1)
            level.getEntitiesWithin(entity.getBoundingBox().inflate(4)).forEach(target => {
                if (
                    target == entity
                ) {
                    return;
                }

                // Calculate the direction from the player to the entity
                let dx = target.getX() - entity.getX()
                let dy = target.getY() - entity.getY()
                let dz = target.getZ() - entity.getZ()
                let dist = Math.sqrt((dx * dx) + (dy * dy) + (dz * dz))
                let knockbackStrength = 1.2
                let vx = (dx / dist) * knockbackStrength
                let vy = (dy / dist) * knockbackStrength
                let vz = (dz / dist) * knockbackStrength
                target.setMotion(vx, vy, vz)
                if (target.isPlayer()) {
                    target.connection.send(new ClientboundSetEntityMotionPacket(target));
                }

                let damageSource = getDamageSourceBothSides(level, "minecraft:player_explosion", entity, target)
                target.attack(damageSource, 6)
            })
            entity.kill()
        }

        if (
            entity.tags.contains('arrz.trick_arrow.ender_pearl')
        ) {
            if (entity.age > 5) {entity.kill()}
            entity.getServer().runCommandSilent(`tp ${owner} ${entity.getX()} ${entity.getY()+1} ${entity.getZ()}`)
            var level = entity.getLevel()
            level.spawnParticles("minecraft:portal", true, entity.getX(), entity.getY(), entity.getZ(), 1.5, 1.5, 1.5, 8, 0)
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), 'minecraft:entity.enderman.teleport', 'master', 1, 1)
            entity.kill()
        }

        if (
            !entity.tags.contains('arrz.trick_arrow.healing') &&
            !entity.tags.contains('arrz.trick_arrow.ender_pearl') &&
            // !entity.tags.contains('arrz.trick_arrow.dampening') &&
            !entity.tags.contains('arrz.trick_arrow.explosive') &&
            !entity.tags.contains('arrz.trick_arrow.knockback')
        ) {
            let bb = entity.getBoundingBox().inflate(0.2, 1.25, 0.2)
            var level = entity.getLevel();
    
            level.getEntitiesWithin(bb).forEach(target => {
                if (
                    target == entity ||
                    target.type != "minecraft:player"
                ) {
                    return;
                }
    
                let arrowIs = -1
                entity.tags.toArray().forEach(tag => {
                    if (arrowConversions.indexOf(tag) != -1) {arrowIs = arrowConversions.indexOf(tag)}
                })
                if (arrowIs == -1) {return}
                target.give(Item.of(arrowMappings[arrowIs]))
                entity.kill()
            })
        }
    };
}

StartupEvents.registry('palladium:condition_serializer', (event) => {

    event.create('arrzenhanced:arrow_index_is')
    .addProperty("size_id", "string", "arrzenhanced.iron_prism.arrow_sel", "ID used for selection")
    .addProperty("index", "integer", 0, "Amount index needs to be equal to")
    .test((entity, props) => {
        if (entity.type != 'minecraft:player') {return false}
        let size_id = props.get("size_id")
        let amount = props.get("amount")
        let playerSize = palladium.getProperty(entity, size_id)
        return playerSize == amount
    })

    event.create('arrzenhanced:has_current_arrow')
    .test((entity, props) => {
        var arrowMappings = {
            "0": "arrzenhanced:trick_arrow_base",
            "1": "arrzenhanced:explosive_arrow",
            "2": "arrzenhanced:healing_arrow",
            "3": "arrzenhanced:diamond_arrow",
            "4": "arrzenhanced:ender_pearl_arrow",
            "5": "arrzenhanced:knockback_arrow",
            "6": "arrzenhanced:dampening_arrow",
            "7": "arrzenhanced:essentium_arrow",
        }
        var chestplateNames = {
            "0": "base_count",
            "1": "explosive_count",
            "2": "healing_count",
            "3": "diamond_count",
            "4": "ender_pearl_count",
            "5": "knockback_count",
            "6": "dampening_count",
            "7": "essentium_count",
        }
        if (entity.type != 'minecraft:player') {return false}
        var currentSelect = palladium.getProperty(entity, 'arrzenhanced.iron_prism.arrow_sel')
        if (arrowMappings[currentSelect.toString()] == undefined) {return}

        var inventory = entity.getInventory()
        let chestplate = inventory.getArmor(2)
        if (chestplate.isEmpty() || chestplate.id != 'arrzenhanced:iron_prism_chestplate') {return}

        let storedArrows = chestplate.nbt.getDouble(chestplateNames[currentSelect])
        if (storedArrows <= 0) {
            return false
        } else {
            return true
        }
    })

    event.create('arrzenhanced:has_no_blade')
    .test((entity, props) => {
        if (entity.type != 'minecraft:player') {return false}
        var inventory = entity.getInventory()
        let chestplate = inventory.getArmor(2)
        if (chestplate.isEmpty() || chestplate.id != 'arrzenhanced:iron_prism_chestplate') {return}

        let storedBlade = chestplate.nbt.getString('StoredPrismBlade')
        if (storedBlade == '') { // uninit
            return false
        } else if (storedBlade == 'empty') { // empty
            return true
        } else { // has contents
            return false
        }
    })

});