let $Vec3 = Java.loadClass('net.minecraft.world.phys.Vec3')

StartupEvents.registry("entity_type", event => {
    event.create('arrzenhanced:prism_racer', 'entityjs:mob')
        .positionRider(context => global.positionRider(context))
        .onInteract(context => {
            if (context.player.isShiftKeyDown()) return
            context.player.startRiding(context.entity);
        })
        .canAddPassenger(context => {
            const maxPassengers = 2;
            return context.entity.getPassengers().size() < maxPassengers;
        })
        // .setJumpControl(entity => {
        //     return EntityJSUtils.createJumpControl(entity, jumpControlBuilder => { })
        // })
        // .setBlockJumpFactor(entity => {
        //     // Sets block jump factor returning a float value
        //     if (entity.age > 2000) {
        //         return 1.7; // Increase jump factor when the entity is old enough
        //     }
        //     return 1.5; // Default jump factor
        // })
        // .calculateFallDamage(context => {
        //     // Define logic to calculate and return the fall damage for the entity
        //     // Use information about the CalculateFallDamageContext provided by the context.
        //     const fallHeight = context.fallHeight;
        //     const damageMultiplier = context.damageMultiplier;
        //     const entity = context.entity;

        //     // Custom logic to calculate fall damage based on fall height and multiplier
        //     const calculatedDamage = Math.floor(fallHeight * damageMultiplier);
        //     return 0;
        // })
        .canStandOnFluid(context => {
            // Define conditions for the entity to be able to stand on a fluid
            // Use information about the EntityFluidStateContext provided by the context.
            // Allow standing on water.
            let fluid = Fluid.of("minecraft:water").fluid.fluidType
            return context.fluidState.fluidType == fluid
        })
        .fireImmune(true)
        .updateInterval(1)
        .canSteer(true)
        // .canJump(true)
        .isPersistenceRequired(true)
        .canBreatheUnderwater(true)
        // .clientTrackingRange(20)
        .sized(1.4, 1)
        .isAlwaysExperienceDropper(false)
        .noEggItem()

    // event.create('arrzenhanced:prism_racer_alt', 'minecraft:horse')
    //     // .positionRider(context => global.positionRider(context))
    //     .onInteract(context => {
    //         if (context.player.isShiftKeyDown()) return
    //         context.player.startRiding(context.entity);
    //     })
    //     .canAddPassenger(context => {
    //         const maxPassengers = 2;
    //         return context.entity.getPassengers().size() < maxPassengers;
    //     })
    //     .calculateFallDamage(context => {
    //         // Define logic to calculate and return the fall damage for the entity
    //         // Use information about the CalculateFallDamageContext provided by the context.
    //         const fallHeight = context.fallHeight;
    //         const damageMultiplier = context.damageMultiplier;
    //         const entity = context.entity;

    //         // Custom logic to calculate fall damage based on fall height and multiplier
    //         const calculatedDamage = Math.floor(fallHeight * damageMultiplier);
    //         return 0;
    //     })
    //     .fireImmune(true)
    //     .mountJumpingEnabled(true)
    //     .updateInterval(1)
    //     .canSteer(true)
    //     .canJump(true)
    //     .isPersistenceRequired(true)
    //     .canBreatheUnderwater(true)
    //     .clientTrackingRange(20)
    //     .defaultBehaviourGoals(false)
    //     .defaultGoals(false)
    //     .sized(1.5, 1)
    //     .isAlwaysExperienceDropper(false)
    //     .noEggItem()

})

global.positionRider = context => {
    let { entity, passenger, moveFunction } = context;
    let passengers = entity.getPassengers();
    entity.setYBodyRot(entity.getControllingPassenger().yaw)
    let index = -1;
    for (let j = 0; j < passengers.size(); j++) {
        if (passengers.get(j) === passenger) {
            index = j;
            break;
        }
    }
    if (index === -1) return;
    let isFront = index === 0;
    let zOffset = -0.1;
    let yOffset = entity.isRemoved()
        ? 0.01 + passenger.getMyRidingOffset()
        : getBodyAnchorYOffset(entity) + passenger.getMyRidingOffset() - 0.4;
    if (passengers.size() > 1) {
        if (!isFront) {
            zOffset = -1.2;
            yOffset += 0.2
        } else {
            zOffset = -0.3;
        }
        if (passenger.isAnimal()) {
            zOffset += 0.2;
        }
    }
    let yawRadians = -entity.yBodyRot * (JavaMath.PI / 180);
    let x = entity.x + Math.sin(yawRadians) * zOffset;
    let z = entity.z + Math.cos(yawRadians) * zOffset;
    moveFunction.accept(passenger, x, entity.y + yOffset, z);
    clampRotation(entity, passenger);
}

function getBodyAnchorYOffset(entity) {
    let ridingOffset = entity.getPassengersRidingOffset() ?? 0;
    let scale = entity.getScale() ?? 1;
    let f = scale * 1.43;
    let f1 = f - scale * 0.2;
    return ridingOffset + (f - f1);
}
function clampRotation(host, target) {
    target.setYBodyRot(host.yaw);
    let f = target.yaw;
    let f1 = KMath.wrapDegrees(f - host.yaw);
    let f2 = KMath.clamp(f1, -160, 160);
    target.yRotO += f2 - f1;
    let f3 = f + f2 - f1;
    target.setYaw(f3);
    target.setYHeadRot(f3);
}