/*
    @author Hertz
    @version 1.0
*/

// const DamageSourceReference = Java.loadClass('net.minecraft.world.damagesource.DamageSource');
// const DamageTypeReference = Java.loadClass('net.minecraft.world.damagesource.DamageType');
let SuperpowerUtil = Java.loadClass('net.threetag.palladium.power.SuperpowerUtil');

StartupEvents.registry('palladium:abilities', (event) => {

    event.create('hertz:lightning_shock')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .addProperty('radius', 'integer', 8, 'Radius to summon lightning in')
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            const radius = entry.getPropertyByName('radius');
            var px = entity.getX();
            var py = entity.getY();
            var pz = entity.getZ();
            var level = entity.getLevel()

            for (let angle = 0; angle < 360; angle += 35) {
                let radians = angle * (JavaMath.PI / 180)
                let xOffset = Math.cos(radians) * radius;
                let zOffset = Math.sin(radians) * radius;

                let mob = level.createEntity("minecraft:lightning_bolt");
                mob.setPosition(px + xOffset, py, pz + zOffset);
                mob.spawn();
            }
        }
    })
});
