/*
    @author Hertz
    @version 1.0
*/

var KJSUtils = Java.loadClass('dev.latvian.mods.kubejs.util.UtilsJS');

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('hertz:orange_lantern_forcefield')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .firstTick((entity, entry, holder, enabled) => {
        if (enabled) {
            return
        }
    })
    .tick((entity, entry, holder, enabled) => global.orangeLanternForcefield(entity, entry, holder, enabled))
    .lastTick((entity, entry, holder, enabled) => {
        if (enabled) {
            return
        }
    });

    event.create('hertz:orange_lantern_forcefield_dummy')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .firstTick((entity, entry, holder, enabled) => {
        if (enabled) {
            var notif = {'Arrz.ShieldNotif': {
                type: 'rectangle',
                x: 30,
                y: 0,
                w: 16,
                h: 20,
                alignX: 'center',
                alignY: 'center',
                texture: 'arrzenhanced:textures/gui/orange_shielded.png',
                draw: 'ingame',
                visible: true
            }} 
            entity.modifyAttribute("minecraft:generic.movement_speed", "a60aec26-b93c-45ca-a758-7655a8da7c67", -5.0, "ADDITION")
            KJSUtils.staticServer.runCommandSilent(`kubejs painter ${entity.name.getString()} ${JSON.stringify(notif)}`)
            return
        }
    })
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            return
        }
    })
    .lastTick((entity, entry, holder, enabled) => {
        if (enabled) {
            var notif = {'Arrz.ShieldNotif': {
                visible: false
            }}
            entity.removeAttribute("minecraft:generic.movement_speed", "a60aec26-b93c-45ca-a758-7655a8da7c67")
            KJSUtils.staticServer.runCommandSilent(`kubejs painter ${entity.name.getString()} ${JSON.stringify(notif)}`)
            return
        }
    });

    event.create('hertz:orange_lantern_forcefield_dummy_alt')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .firstTick((entity, entry, holder, enabled) => {
        if (enabled) {
            var px = entity.getX();
            var py = entity.getY();
            var pz = entity.getZ();
            var notif = {'Arrz.ShieldNotif': {
                type: 'rectangle',
                x: 30,
                y: 0,
                w: 16,
                h: 20,
                alignX: 'center',
                alignY: 'center',
                texture: 'arrzenhanced:textures/gui/orange_shielded.png',
                draw: 'ingame',
                visible: true
            }} 
            entity.modifyAttribute("minecraft:generic.movement_speed", "a60aec26-b93c-45ca-a758-7655a8da7c67", -5.0, "ADDITION")
            entity.modifyAttribute("palladium:flight_speed", "df00851e-6f21-404e-b58a-066fd1798761", -0.9, "ADDITION")
            entity.modifyAttribute("palladium:levitation_speed", "3e3283da-5737-498e-a23c-bce96b654c81", -0.9, "ADDITION")
            // entity.modifyAttribute("palladium:leaping", "819880cb-ee1c-41e5-9448-529b1bb69fac", -1.0, "ADDITION")
            KJSUtils.staticServer.runCommandSilent(`kubejs painter ${entity.name.getString()} ${JSON.stringify(notif)}`)
            KJSUtils.staticServer.runCommandSilent(`playsound arrzenhanced:ol_construct_form player @a[distance=..8] ${px} ${py} ${pz} 1 1`)
            return
        }
    })
    .tick((entity, entry, holder, enabled) => global.orangeLanternForcefieldAlt(entity, entry, holder, enabled))
    .lastTick((entity, entry, holder, enabled) => {
        if (enabled) {
            var px = entity.getX();
            var py = entity.getY();
            var pz = entity.getZ();
            var notif = {'Arrz.ShieldNotif': {
                visible: false
            }}
            entity.removeAttribute("minecraft:generic.movement_speed", "a60aec26-b93c-45ca-a758-7655a8da7c67")
            entity.removeAttribute("palladium:flight_speed", "df00851e-6f21-404e-b58a-066fd1798761")
            entity.removeAttribute("palladium:levitation_speed", "3e3283da-5737-498e-a23c-bce96b654c81")
            // entity.removeAttribute("palladium:leaping", "819880cb-ee1c-41e5-9448-529b1bb69fac")
            KJSUtils.staticServer.runCommandSilent(`kubejs painter ${entity.name.getString()} ${JSON.stringify(notif)}`)
            KJSUtils.staticServer.runCommandSilent(`playsound arrzenhanced:ol_construct_deconstruct player @a[distance=..8] ${px} ${py} ${pz} 1 1`)
            return
        }
    });
});

global.orangeLanternForcefield = (entity, entry, holder, enabled) => {
    if (enabled) {
        let player = entity
        let lookAngle = entity.getLookAngle().scale(1.5)
        let playerLocation = Vec3d(
            player.getX(),
            (player.getY() + 0.0), // formerly 1.0
            player.getZ()
        )
        let targetLocation = Vec3d(
            (playerLocation.x() + lookAngle.x()),
            (playerLocation.y() + lookAngle.y()),
            (playerLocation.z() + lookAngle.z())
        )
        let particle = Utils.particleOptions('dust 1.000 0.533 0 1')
        let rightVec = lookAngle.cross(new Vec3d(0,1,0)).normalize()
        let leftVec = lookAngle.cross(new Vec3d(0,1,0)).normalize().scale(-1)
        let partPosRight = Vec3d(
            (targetLocation.x() + rightVec.x()),
            (targetLocation.y() + rightVec.y()),
            (targetLocation.z() + rightVec.z())
        )
        let partPosRightMidLeft = Vec3d(
            (targetLocation.x() + rightVec.x()*0.25),
            (targetLocation.y() + rightVec.y()*0.25),
            (targetLocation.z() + rightVec.z()*0.25)
        )
        let partPosRightMid = Vec3d(
            (targetLocation.x() + rightVec.x()*0.5),
            (targetLocation.y() + rightVec.y()*0.5),
            (targetLocation.z() + rightVec.z()*0.5)
        )
        let partPosRightMidRight = Vec3d(
            (targetLocation.x() + rightVec.x()*0.75),
            (targetLocation.y() + rightVec.y()*0.75),
            (targetLocation.z() + rightVec.z()*0.75)
        )
        let partPosLeft = Vec3d(
            (targetLocation.x() + leftVec.x()),
            (targetLocation.y() + leftVec.y()),
            (targetLocation.z() + leftVec.z())
        )
        let partPosLeftMidLeft = Vec3d(
            (targetLocation.x() + leftVec.x()*0.25),
            (targetLocation.y() + leftVec.y()*0.25),
            (targetLocation.z() + leftVec.z()*0.25)
        )
        let partPosLeftMid = Vec3d(
            (targetLocation.x() + leftVec.x()*0.5),
            (targetLocation.y() + leftVec.y()*0.5),
            (targetLocation.z() + leftVec.z()*0.5)
        )
        let partPosLeftMidRight = Vec3d(
            (targetLocation.x() + leftVec.x()*0.75),
            (targetLocation.y() + leftVec.y()*0.75),
            (targetLocation.z() + leftVec.z()*0.75)
        )
        for (var i = 0; i <= 2.5; i += 0.25) {
            player.getLevel().spawnParticles(particle, true, targetLocation.x(), targetLocation.y()+i, targetLocation.z(), 0, 0, 0, 1, 0)
            player.getLevel().spawnParticles(particle, true, partPosRight.x(), partPosRight.y()+i, partPosRight.z(), 0, 0, 0, 1, 0)
            player.getLevel().spawnParticles(particle, true, partPosLeft.x(), partPosLeft.y()+i, partPosLeft.z(), 0, 0, 0, 1, 0)
            player.getLevel().spawnParticles(particle, true, partPosRightMid.x(), partPosRightMid.y()+i, partPosRightMid.z(), 0, 0, 0, 1, 0)
            player.getLevel().spawnParticles(particle, true, partPosLeftMid.x(), partPosLeftMid.y()+i, partPosLeftMid.z(), 0, 0, 0, 1, 0)


            player.getLevel().spawnParticles(particle, true, partPosRightMidLeft.x(), partPosRightMidLeft.y()+i, partPosRightMidLeft.z(), 0, 0, 0, 1, 0)
            player.getLevel().spawnParticles(particle, true, partPosRightMidRight.x(), partPosRightMidRight.y()+i, partPosRightMidRight.z(), 0, 0, 0, 1, 0)
            player.getLevel().spawnParticles(particle, true, partPosLeftMidLeft.x(), partPosLeftMidLeft.y()+i, partPosLeftMidLeft.z(), 0, 0, 0, 1, 0)
            player.getLevel().spawnParticles(particle, true, partPosLeftMidRight.x(), partPosLeftMidRight.y()+i, partPosLeftMidRight.z(), 0, 0, 0, 1, 0)
        }
    }
}
global.orangeLanternForcefieldAlt = (entity, entry, holder, enabled) => {
    if (enabled) {
        let player = entity
        let level = player.getLevel()
        let radius = 1.05
        let particle = Utils.particleOptions('dust 1.000 0.533 0 1')
        let particleCount = 50

        for (let i = 0; i < particleCount; i++) {
            let theta = Math.acos(2 * Math.random() - 1); // Polar angle
            let phi = 2 * JavaMath.PI * Math.random(); // Azimuthal angle
    
            // Spherical to Cartesian conversion
            let xOffset = radius * Math.sin(theta) * Math.cos(phi);
            let yOffset = radius * Math.sin(theta) * Math.sin(phi);
            let zOffset = radius * Math.cos(theta);
    
            // Spawn the particle at the calculated offset
            level.spawnParticles(
                particle,
                true,
                player.x + xOffset,
                player.y + yOffset + 1, // Adjust for player's height
                player.z + zOffset,
                0, 0, 0, // No velocity for static particles
                1, // Count
                0 // ?
            );
        }
    }
}

ForgeEvents.onEvent('net.minecraftforge.event.entity.living.LivingHurtEvent', event => {
    var { amount } = event
    
    // let powers = abilityUtil.getEntries(event.entity, "hertz:orange_lantern_forcefield_dummy")
    let powers = abilityUtil.getEntries(event.entity, "hertz:orange_lantern_forcefield_dummy_alt")
    let allsuperpowers = palladium.powers.getPowerIds(event.entity)
    var done = false;
    
    for (var i = 0; i < powers.length; i++) { // for each instance of being able to block
        // event.entity.tell(powers[i].id);
        for (var x = 0; x < allsuperpowers.length; x++) { // run it against each power
            // event.entity.tell(allsuperpowers[i]);
            if (abilityUtil.isEnabled(event.entity, allsuperpowers[x], powers[i].id)) { // if it matches and is enabled
                if (!done) {
                    event.setAmount(0);
                    done = true
                }
            }
        }
    }
})