/*
    @author Hertz
    @version 1.0
*/

var scales = {
    "-2": 0.25,
    "-1": 0.50,
    "0": 1,
    "1": 2.5
}
var damageScales = {
    "-2": -2,
    "-1": -1,
    "0": 0,
    "1": 2.5,
    "2": 5
}
var jabRanges = {
    "-3": 0.05,
    "-2": 0.25,
    "-1": 0.50,
    "0": 1,
    "1": 2.5,
    "2": 4,
    "3": 7
}

StartupEvents.registry('palladium:abilities', (event) => {
    
    event.create('arrzenhanced:change_size')
    .icon(palladium.createItemIcon('minecraft:feather'))
    .addProperty('operation', 'string', 'shrink', 'shrink / grow / reset')
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            var operation = entry.getPropertyByName('operation')
            var currentSize = palladium.getProperty(entity, 'arrzenhanced.size')
            var pre = currentSize
            if (operation == 'shrink') {currentSize -= 1}
            else if (operation == 'grow') {currentSize += 1}
            else if (operation == 'reset') {currentSize = 0}
            else if (operation == 'background') {return;}

            if (scales[currentSize.toString()] == undefined) {return}
            entity.getServer().runCommandSilent(`scale set ${scales[currentSize.toString()]} ${entity.uuid.toString()}`)
            entity.getServer().runCommandSilent(`scale set pehkui:motion ${1/scales[currentSize.toString()]} ${entity.uuid.toString()}`)
            // entity.getServer().runCommandSilent(`scale set pehkui:reach ${1*scales[currentSize.toString()]} ${entity.uuid.toString()}`)
            // ORIGINALLY 20
            entity.getServer().runCommandSilent(`scale delay set pehkui:motion 5 ${entity.uuid.toString()}`)
            entity.getServer().runCommandSilent(`scale easing set pehkui:motion pehkui:exponential_out ${entity.uuid.toString()}`)
            entity.getServer().runCommandSilent(`scale delay set pehkui:base 5 ${entity.uuid.toString()}`)
            entity.getServer().runCommandSilent(`scale easing set pehkui:base pehkui:exponential_out ${entity.uuid.toString()}`)
            
            if (pre != currentSize) {
                entity.getLevel().playSound(null, entity.getX(), entity.getY(), entity.getZ(), 'arrzenhanced:photon.size_change', 'master', 0.6, 1)
            }

            entity.modifyAttribute("palladium:punch_damage", "0bb5d801-d55c-4cad-9138-fc5671d86e0a", damageScales[currentSize.toString()], "ADDITION")

            palladium.setProperty(entity, 'arrzenhanced.size', currentSize);
        };
    })
    .lastTick((entity, entry, holder, enabled) => {
        // entity.getServer().tell("lasttick")
        // if (enabled) {
        var operation = entry.getPropertyByName('operation')
        if (operation == 'background') {
            var currentSize = 0

            if (scales[currentSize.toString()] == undefined) {return}
            entity.getServer().runCommandSilent(`scale set ${scales[currentSize.toString()]} ${entity.uuid.toString()}`)
            entity.getServer().runCommandSilent(`scale set pehkui:motion ${1/scales[currentSize.toString()]} ${entity.uuid.toString()}`)
            // ORIGINALLY 20
            entity.getServer().runCommandSilent(`scale delay set pehkui:motion 5 ${entity.uuid.toString()}`)
            entity.getServer().runCommandSilent(`scale easing set pehkui:motion pehkui:exponential_out ${entity.uuid.toString()}`)
            entity.getServer().runCommandSilent(`scale delay set pehkui:base 5 ${entity.uuid.toString()}`)
            entity.getServer().runCommandSilent(`scale easing set pehkui:base pehkui:exponential_out ${entity.uuid.toString()}`)
            
            entity.getLevel().playSound(null, entity.getX(), entity.getY(), entity.getZ(), 'arrzenhanced:photon.size_change', 'master', 0.6, 1)

            entity.removeAttribute("palladium:punch_damage", "0bb5d801-d55c-4cad-9138-fc5671d86e0a")

            palladium.setProperty(entity, 'arrzenhanced.size', currentSize);
            }
        // }
    })
});

StartupEvents.registry('palladium:condition_serializer', (event) => {

    event.create('arrzenhanced:size_is')
    .addProperty("size_id", "string", "arrzenhanced.size", "ID used for size control")
    .addProperty("amount", "integer", 0, "Amount control needs to be equal to")
    .test((entity, props) => {
        let size_id = props.get("size_id")
        let amount = props.get("amount")
        let playerSize = palladium.getProperty(entity, size_id)
        return playerSize == amount
    })

    event.create('arrzenhanced:size_below')
    .addProperty("size_id", "string", "arrzenhanced.size", "ID used for size control")
    .addProperty("amount", "integer", 0, "Amount control needs to be below")
    .test((entity, props) => {
        let size_id = props.get("size_id")
        let amount = props.get("amount")
        let playerSize = palladium.getProperty(entity, size_id)
        return playerSize < amount
    })

});