/*
    @author Hertz
    @version 1.0
*/

var BuiltInRegistries = Java.loadClass("net.minecraft.core.registries.BuiltInRegistries")

function resolveAllegedBooleanFromObject(thing) {
    if (thing.toString() == 'true') { return true; }
    if (thing.toString() == 'false') { return false; }
    return null
}

StartupEvents.registry('palladium:condition_serializer', (event) => {

    event.create('arrzenhanced:safe_has_effect_check')
    .addProperty("effect", "string", "minecraft:health_boost", "Effect to search for")
    .test((entity, props) => {
        let targetEffect = props.get("effect")
        var toReturn = false
        
        if (entity.activeEffects.size() > 0) {
            entity.activeEffects.toArray().forEach((iteratedEffect) => {
                if (toReturn) return
                var currentEffectPath = BuiltInRegistries.MOB_EFFECT.getKey(iteratedEffect.effect).toString()
                if (currentEffectPath == targetEffect) {
                    toReturn = true
                }
            })
        }
        return toReturn
    })
});