/*
    @author Hertz
    @version 1.0
*/

var $SuperpowerUtil = Java.loadClass('net.threetag.palladium.power.SuperpowerUtil')

StartupEvents.registry('mob_effect', event => {
    event.create('arrzenhanced:velocity')
        .displayName("Velocity")
        .color(0x0000FF)
        .harmful()
        .effectTick((entity, lvl) => global.velocityEffect(entity, lvl));
})


global.velocityEffect = (entity, lvl) => {
    if (entity.getLevel().clientSide) return;
    if (entity.age % 20 == 0 && palladium.powers.getPowerIds(entity).length > 0) {
        // entity.attack(damageSource, 2 * lvl);
        // entity.attack(2 * (lvl+1));
    }
}

StartupEvents.registry('palladium:abilities', (event) => {
    
    event.create('arrzenhanced:inject_velocity')
    .icon(palladium.createItemIcon('arrzenhanced:velocity_injector'))
    .firstTick((entity, entry, holder, enabled) => global.inject_velocity_tick(entity, entry, holder, enabled))

});

global.inject_velocity_tick = (entity, entry, holder, enabled) => {
    
    if (enabled) {
        let power = entity.mainHandItem.getNbt().level
        if (power == undefined) { power = 0 }
        if (power == 0) { entity.mainHandItem.count--; entity.kill(); return; }
        else if (power <= 4) { entity.potionEffects.add('minecraft:wither', 10 * 60 * 20, 9, false, false) }
        else if (power <= 6) { entity.potionEffects.add('minecraft:poison', 20 * 20, 1, false, false) }
        else if (power <= 8) { entity.potionEffects.add('minecraft:poison', 10 * 20, 0, false, false) }
        else if (power >= 9) { entity.potionEffects.add('minecraft:regeneration', 60 * 20, 1, false, false) }

        if (power <= 7) { entity.potionEffects.add("arrzenhanced:velocity", 3 * 60 * 20, power, false, false) }
        else { entity.potionEffects.add("arrzenhanced:velocity", 5 * 60 * 20, power, false, false) }
        entity.mainHandItem.count--
    }

}


// https://mcstreetguy.github.io/ForgeJavaDocs/1.20.1-latest/net/minecraftforge/event/entity/living/MobEffectEvent.Added.html
ForgeEvents.onEvent('net.minecraftforge.event.entity.living.MobEffectEvent$Added', event => global.velocityAddedEffectCheck(event))
ForgeEvents.onEvent('net.minecraftforge.event.entity.living.MobEffectEvent$Expired', event => global.velocityRemovedEffectCheck(event))
ForgeEvents.onEvent('net.minecraftforge.event.entity.living.MobEffectEvent$Remove', event => global.velocityRemovedEffectCheck(event))

var fx = [
    "effect.arrzenhanced.velocity"
]
global.velocityAddedEffectCheck = event => {
    let entity = event.entity
    if (entity.deathTime == 0 && fx.includes(event.effectInstance?.descriptionId) && entity.type == "minecraft:player") {
        
        var speedMax = palladium.getProperty(entity, 'arrzenhanced.maxSpeed')
        var tachyonBoost = palladium.getProperty(entity, 'arrzenhanced.tachyonBoost')
        var velocityBoost = palladium.getProperty(entity, 'arrzenhanced.velocityBoost')
        var oldSpeedColor = palladium.getProperty(entity, 'arrzenhanced.oldSpeedColor')
        var speedColor = palladium.getProperty(entity, 'arrzenhanced.speedColor')
        var realSpeed = (speedMax - tachyonBoost) - velocityBoost
        
        let amp = event.effectInstance.getAmplifier()

        if (amp < 9) { // if below VX (unsafe!)
            if (oldSpeedColor == speedColor) {
                palladium.setProperty(entity, 'arrzenhanced.oldSpeedColor', speedColor)
                palladium.setProperty(entity, 'arrzenhanced.speedColor', 3)
            } else {
                palladium.setProperty(entity, 'arrzenhanced.speedColor', 3)
            }
        }

        
        // let hasPowers = palladium.powers.getPowerIds(entity).size() >= 1
        // if (!hasPowers && !entity.tags.contains('arrz.velocitySpeedforce')) {
        let pow = palladium.powers.getPowerIds(entity)
        let hasSpeedforce = false
        pow.forEach(power => {
            if (power == "arrzenhanced:speedforce") hasSpeedforce = true
        })
        if (!hasSpeedforce && !entity.tags.contains('arrz.velocitySpeedforce')) {
            entity.tags.add("arrz.velocitySpeedforce")
            $SuperpowerUtil.addSuperpower(entity, "arrzenhanced:speedforce")
            //
            var tachyonBoost = palladium.getProperty(entity, 'arrzenhanced.tachyonBoost')
            var velocityBoost = palladium.getProperty(entity, 'arrzenhanced.velocityBoost')
            var newVelo = velocityBoost+1
            palladium.setProperty(entity, 'arrzenhanced.maxSpeed', tachyonBoost+newVelo)
        } else if (!hasSpeedforce && entity.tags.contains('arrz.velocitySpeedforce')) {
            $SuperpowerUtil.addSuperpower(entity, "arrzenhanced:speedforce")
        }


        if (entity.tags.contains('arrz.velocitySpeedforce')) {
            if (realSpeed < 12 && realSpeed <= amp) {
                // let top = speedMax+(Math.ceil(amp/3)) < 6 ? speedMax+(Math.ceil(amp/3)) : 6
                // top = top < 1 ? 1 : top
                palladium.setProperty(entity, 'arrzenhanced.maxSpeed', speedMax+1)
            }
        } else {
            // velocityBoost
            var newVelo = velocityBoost+1,
            totalSpeed = realSpeed+tachyonBoost+newVelo
            if (totalSpeed >= 12) {
                // hard limit
                totalSpeed = 12
                newVelo = 12 - (realSpeed+tachyonBoost)
            }
            palladium.setProperty(entity, 'arrzenhanced.velocityBoost', newVelo)
            palladium.setProperty(entity, 'arrzenhanced.maxSpeed', totalSpeed)
        }
    }
}

global.velocityRemovedEffectCheck = event => {
    let entity = event.entity
    if (entity.deathTime == 0 && fx.includes(event.effectInstance?.descriptionId) && entity.type == "minecraft:player") {
        if (entity.tags.contains('arrz.velocitySpeedforce')) {
            entity.tags.remove("arrz.velocitySpeedforce")
            $SuperpowerUtil.removeSuperpower(entity, "arrzenhanced:speedforce")

            palladium.setProperty(entity, 'arrzenhanced.maxSpeed', 1)
            palladium.setProperty(entity, 'arrzenhanced.speedExperience', 0)

            // reset speed
            entity.removeAttribute("minecraft:generic.movement_speed", "45d66472-0057-4ecf-9785-aa1c36bc54de")
            entity.removeAttribute("palladium:destroy_speed", "3529782e-8ce4-4d2b-9d74-0efd983c4034")

            entity.tags.remove('arrz.speedburst.active');
            palladium.setProperty(entity, 'arrzenhanced.speedActive', false);

            palladium.setProperty(entity, 'arrzenhanced.speed', 0);
        } else {
            var speedMax = palladium.getProperty(entity, 'arrzenhanced.maxSpeed')
            var tachyonBoost = palladium.getProperty(entity, 'arrzenhanced.tachyonBoost')
            var velocityBoost = palladium.getProperty(entity, 'arrzenhanced.velocityBoost')
            var realSpeed = (speedMax - tachyonBoost) - velocityBoost

            //
            let totalSpeed = realSpeed+tachyonBoost
            palladium.setProperty(entity, 'arrzenhanced.velocityBoost', 0)
            if (totalSpeed == 0) {
                palladium.setProperty(entity, 'arrzenhanced.maxSpeed', 1)
            } else {
                palladium.setProperty(entity, 'arrzenhanced.maxSpeed', totalSpeed)
            }
        }

        let amp = event.effectInstance.getAmplifier()
        if (amp < 9) { // if below VX (unsafe!)
            var oldSpeedColor = palladium.getProperty(entity, 'arrzenhanced.oldSpeedColor')
            palladium.setProperty(entity, 'arrzenhanced.speedColor', oldSpeedColor)
        }
    }
}