/*
    @author Hertz
    @version 1.0
*/

var $SuperpowerUtil = Java.loadClass('net.threetag.palladium.power.SuperpowerUtil')

let $ResourceKey = Java.loadClass("net.minecraft.resources.ResourceKey")
let DAMAGE_TYPE = $ResourceKey.createRegistryKey("damage_type")

function getDamageSourceOneSided(
    /** @type {Internal.Level}*/ level,
    /** @type {Internal.DamageType_}*/ damageType
    ) {
    var resourceKey = $ResourceKey.create(DAMAGE_TYPE, Utils.id(damageType))
    var holder = level.registryAccess().registryOrThrow(DAMAGE_TYPE).getHolderOrThrow(resourceKey)
    var damagesourceholder = holder
    return new DamageSource(damagesourceholder)
}

StartupEvents.registry('mob_effect', event => {
    event.create('arrzenhanced:gamma_radiation')
        .displayName("Gamma Radiation")
        .color(0x00FF00)
        .harmful()
        .effectTick((entity, lvl) => global.gammaEffect(entity, lvl));
})


global.gammaEffect = (entity, lvl) => {
    if (entity.getLevel().clientSide) return;
    if (palladium.abilities.hasPower(entity, "arrzenhanced:hazmat_suit")) {
        entity.removeEffect('arrzenhanced:gamma_radiation')
        return;
    }
    if (entity.age % 80 == 0) {
        let dmgSrc = getDamageSourceOneSided(entity.getLevel(), "arrzenhanced:gamma_radiation")
        entity.attack(dmgSrc, 2 * (lvl+1));
    }
    if (!entity.potionEffects) {return}
    entity.potionEffects.add("minecraft:nausea", 5 * 20, 0, false, false)
}