let $ResourceKey_ = Java.loadClass("net.minecraft.resources.ResourceKey")
let DAMAGE_TYPE_KEY = $ResourceKey_.createRegistryKey("damage_type")

function getDamageSourceBothSides(
    /** @type {Internal.Level}*/ level,
    /** @type {Internal.DamageType_}*/ damageType,
    /** @type {Internal.LivingEntity}*/ destEntity,
    /** @type {Internal.LivingEntity}*/ sourceEntity
    ) {
    var resourceKey = $ResourceKey_.create(DAMAGE_TYPE_KEY, Utils.id(damageType))
    var holder = level.registryAccess().registryOrThrow(DAMAGE_TYPE_KEY).getHolderOrThrow(resourceKey)
    var damagesourceholder = holder
    return new DamageSource(damagesourceholder, sourceEntity, destEntity)
}

StartupEvents.registry('palladium:abilities', (event) => {
    event.create("arrzenhanced:aoe_damage_orig")
    .icon(palladium.createItemIcon("minecraft:barrier"))
    .addProperty("radius", "integer", 10, "Radius in which surrounding entities will be damaged")
    .addProperty("damage", "float", 3.0, "Damage the ability will deal")
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            let damage = entry.getPropertyByName("damage"),
            radius = entry.getPropertyByName("radius") * 1.0,
            coords = entity.position()
    
            let level = entity.getLevel()
            level.getEntitiesWithin(AABB.of(
                coords.x() + radius,
                coords.y() + radius,
                coords.z() + radius,
                coords.x() - radius,
                coords.y() - radius,
                coords.z() - radius
            )).forEach(target => {
                if (
                    target !== entity &&
                    target.type !== "minecraft:item" &&
                    target.type !== "minecraft:item_frame" &&
                    target.type !== "minecraft:glow_item_frame" &&
                    target.type !== "minecraft:armor_stand" &&
                    target.type !== "palladium:suit_stand"
                ) {
                    let damageSource = getDamageSourceBothSides(level, "minecraft:player_attack", entity, target)
                    target.attack(damageSource, damage)
                }
            })
        }
    })
});