/*
    @author Hertz
    @version 1.0
*/

var $SuperpowerUtil = Java.loadClass('net.threetag.palladium.power.SuperpowerUtil')

StartupEvents.registry('palladium:abilities', (event) => {
    
    event.create('arrzenhanced:inject_others')
    .icon(palladium.createItemIcon('arrzenhanced:empty_injector'))
    .firstTick((entity, entry, holder, enabled) => global.inject_others(entity, entry, holder, enabled))

});

global.inject_others = (entity, entry, holder, enabled) => {
    if (enabled) {
        if (entity.mainHandItem.id == 'arrzenhanced:witherbone_alloy_injector') {
            let injections = palladium.getProperty(entity, 'arrzenhanced.witherblade.injection_count')
            entity.potionEffects.add('minecraft:wither', 10 * 60 * 20, 2, false, false)
            if (injections < 5) {
                palladium.setProperty(entity, 'arrzenhanced.witherblade.injection_count', injections+1)
            } else {
                let allPowers = palladium.powers.getPowerIds(entity),
                hasPowers = false,
                ignorePowers = ['arrzenhanced:concussed', 'arrzenhanced:incognito', 'arrzenhanced:shocked']
                allPowers.forEach(power => {
                    if (palladium.superpowers.hasSuperpower(entity, power) == true && !ignorePowers.includes(power.toString())) {hasPowers = true}
                })
                if (!hasPowers) {
                    palladium.superpowers.addSuperpower(entity, "arrzenhanced:witherblade")
                }
                palladium.setProperty(entity, 'arrzenhanced.witherblade.injection_count', 0)
                entity.removeEffect('minecraft:wither')
            }
            entity.mainHandItem.count--
        } else if (entity.mainHandItem.id == 'arrzenhanced:compound_v_injector') {
            let allPowers = palladium.powers.getPowerIds(entity),
            hasPowers = false,
            ignorePowers = ['arrzenhanced:concussed', 'arrzenhanced:incognito', 'arrzenhanced:shocked']
            allPowers.forEach(power => {
                if (palladium.superpowers.hasSuperpower(entity, power) == true && !ignorePowers.includes(power.toString())) {hasPowers = true}
            })
            if (!hasPowers) {
                if (Math.random() < 0.2) {
                    palladium.superpowers.addSuperpower(entity, "arrzenhanced:hyperior")
                } else {
                    entity.potionEffects.add('arrzenhanced:concussed', 60 * 20, 0, false, false)
                    entity.potionEffects.add('arrzenhanced:shocked', 60 * 20, 0, false, false)
                    entity.potionEffects.add('minecraft:wither', 60 * 20, 0, false, false)
                }
            }
            entity.mainHandItem.count--
        }
    }
}