/*
    @author Hertz
    @version 1.0
*/

function resolveAllegedBooleanFromObject(thing) {
    if (thing.toString() == 'true') { return true; }
    if (thing.toString() == 'false') { return false; }
    return null
}

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:offset_projectile_alt')
    .icon(palladium.createItemIcon('minecraft:arrow'))
    .addProperty('entity_type', 'string', 'palladium:custom_projectile', 'Entity type')
    .addProperty('entity_data', 'compound_tag', null, 'NBT Data')
    .addProperty('hand', 'string', null, 'mainhand or offhand, overwrites yawOffset & pitchOffset!')
    .addProperty('yawOverride', 'integer', -999, 'Yaw Override')
    .addProperty('pitchOverride', 'integer', -999, 'Pitch Override')
    .addProperty('yawOffset', 'integer', -999, 'Yaw Offset')
    .addProperty('pitchOffset', 'integer', -999, 'Pitch Offset')
    .addProperty('frontOffset', 'float', -999, 'Front Offset')
    .addProperty('speed', 'integer', 5, 'Speed')
    .addProperty('swing', 'boolean', true, 'Swing Arm t/f')
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            var type = entry.getPropertyByName('entity_type')
            var nbt = entry.getPropertyByName('entity_data')
    
            var yawOverride = entry.getPropertyByName('yawOverride')
            var pitchOverride = entry.getPropertyByName('pitchOverride')
            var yawOffset = entry.getPropertyByName('yawOffset')
            var pitchOffset = entry.getPropertyByName('pitchOffset')
            var frontOffset = entry.getPropertyByName('frontOffset')
    
            var speed = entry.getPropertyByName('speed')
            var swing = resolveAllegedBooleanFromObject(entry.getPropertyByName('swing'))
    
            var mainarm = entity.getMainArm()
            var hand = entry.getPropertyByName('hand')
            if (hand == "mainhand") {
                if (mainarm == "RIGHT") {
                    yawOffset = 20
                    pitchOffset = 25
                } else if (mainarm == "LEFT") {
                    yawOffset = -20
                    pitchOffset = 25
                }
                if (swing) {
                    entity.swing("MAIN_HAND", true)
                }
            } else if (hand == "offhand") {
                if (mainarm == "RIGHT")  { // WHICH MEANS WE WANT TO SHOOT FROM THE LEFT
                    yawOffset = -20
                    pitchOffset = 25
                } else if (mainarm == "LEFT") {
                    yawOffset = 20
                    pitchOffset = 25
                }
                if (swing) {
                    entity.swing("OFF_HAND", true)
                }
            }
    
            var projectile = entity.block.createEntity(type);
            projectile.mergeNbt(nbt);
    
            var pitch = -toRadians(entity.getPitch() + pitchOffset);
            var yaw = -toRadians(entity.getYaw() + yawOffset);
    
            if (pitchOverride != -999) pitch = toRadians(pitchOverride);
            if (yawOverride != -999) yaw = toRadians(yawOverride);
    
            var x = entity.getX() + Math.cos(pitch) * Math.sin(yaw),
            y = entity.getY() + entity.getEyeHeight() + Math.sin(pitch),
            z = entity.getZ() + Math.cos(pitch) * Math.cos(yaw);
    
            if (frontOffset != -999) {
                x = entity.getX() + (Math.cos(pitch) * Math.sin(yaw)) + (frontOffset * Math.sin(yaw)),
                y = entity.getY() + entity.getEyeHeight() + Math.sin(pitch),
                z = entity.getZ() + (Math.cos(pitch) * Math.cos(yaw)) + (frontOffset * Math.cos(yaw));
            }
            
            projectile.setPos(x, y, z)
            projectile.setDeltaMovement(entity.getLookAngle().scale(speed))
            projectile.setRotation(-entity.getYaw(), -entity.getPitch())
    
            projectile.setOwner(entity)
            projectile.spawn()
        }
    })
})

function toRadians (deg) {
    return deg * (JavaMath.PI / 180)
}