/*
    @author Hertz
    @version 1.0
*/

var $SuperpowerUtil = Java.loadClass('net.threetag.palladium.power.SuperpowerUtil')
let $ResourceKey = Java.loadClass("net.minecraft.resources.ResourceKey")
let DAMAGE_TYPE = $ResourceKey.createRegistryKey("damage_type")

function getDamageSourceOneSided(
    /** @type {Internal.Level}*/ level,
    /** @type {Internal.DamageType_}*/ damageType
    ) {
    var resourceKey = $ResourceKey.create(DAMAGE_TYPE, Utils.id(damageType))
    var holder = level.registryAccess().registryOrThrow(DAMAGE_TYPE).getHolderOrThrow(resourceKey)
    var damagesourceholder = holder
    return new DamageSource(damagesourceholder)
}

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:shock_punch')
    .icon(palladium.createItemIcon('minecraft:lightning_rod'))
    .tick((entity, entry, holder, enabled) => {return})
});

StartupEvents.registry('mob_effect', event => {
    event.create('arrzenhanced:shocked')
        .displayName("Shocked")
        .color(0x00FFFF)
        .harmful()
        .effectTick((entity, lvl) => global.shockedEffect(entity, lvl));
})

global.shockedEffect = (entity, lvl) => {
    if (entity.getLevel().clientSide) return;
    $SuperpowerUtil.addSuperpower(entity, "arrzenhanced:shocked")
    if (entity.age % 40 == 0) {
        let dmgSrc = getDamageSourceOneSided(entity.getLevel(), "minecraft:lightning_bolt")
        entity.attack(dmgSrc, 2 * (lvl+1));
    }
}