/*
    @author Hertz
    @version 1.0
*/

StartupEvents.registry('palladium:abilities', (event) => {
    
    event.create('arrzenhanced:vanilla_flight')
    .icon(palladium.createItemIcon('minecraft:note_block'))
    .firstTick((entity, entry, holder, enabled) => {
        if (enabled) {
            if (!entity.isCreative()) {
                entity.abilities.mayfly = true;
                // entity.abilities.isFlying = true;
            }
            entity.onUpdateAbilities()
        }
    })
    .tick((entity, entry, holder, enabled) => {
        if (!entity.isCreative()) {
            entity.abilities.mayfly = true;
            // entity.abilities.flying = true;
            entity.onUpdateAbilities()
        }
    })
    .lastTick((entity, entry, holder, enabled) => {
        if (!entity.isCreative()) {
            entity.abilities.mayfly = false; // Disable flight when power is removed
            entity.abilities.flying = false;
        }
        entity.onUpdateAbilities()
    });
});