/*
    @author Hertz
    @version 1.0
*/

function resolveAllegedBooleanFromObject(thing) {
    if (thing.toString() == 'true') { return true; }
    if (thing.toString() == 'false') { return false; }
    return null
}

StartupEvents.registry('palladium:abilities', (event) => {
    
    event.create('arrzenhanced:raycast_give_effect')
    .icon(palladium.createItemIcon('minecraft:skeleton_skull'))
    .addProperty('distance', 'integer', 5, 'Max distance to raycast')
    .tick((entity, entry, holder, enabled) => global.raycastGiveEffect(entity, entry, holder, enabled));

});

global.raycastGiveEffect = (entity, entry, holder, enabled) => {
    if (enabled) {
        var dist = entry.getPropertyByName('distance');
        var level = entity.getLevel()
        var victim = advancedRayTrace(entity, level, dist).entity
        if (!victim) return
        
        if (!victim?.potionEffects) return
        victim.potionEffects.add("arrzenhanced:concussed", 25, 0, false, false)
    }
}