PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/discipline', 1, (builder) => {
        let progress_reaper_anim = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:discipline_of_the_code', 'code_reaper_anim', builder.getPartialTicks());

        if (progress_reaper_anim > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('left_leg')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('Linear', progress_reaper_anim);

                builder.get('right_leg')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('Linear', progress_reaper_anim);
            }
        }
    });
});


PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/soul', 1, (builder) => {

        let progress_soulright = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:souls_of_the_code', 'right_arm', builder.getPartialTicks());
        if (progress_soulright > 0 && !builder.isFirstPerson()) {
            const halfPi = 1.57079632679;

        builder.get('right_arm')
            .setXRot(builder.getModel().head.xRot - halfPi + 0.6)
            .setYRot(builder.getModel().head.yRot)
            .setZRot(builder.getModel().head.zRot)
            .animate('Linear', progress_soulright);

        }

        let progress_soulleft = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:souls_of_the_code', 'left_arm', builder.getPartialTicks());
        if (progress_soulleft > 0 && !builder.isFirstPerson()) {
            const halfPi = 1.57079632679;

        builder.get('left_arm')
            .setXRot(builder.getModel().head.xRot - halfPi + 0.6)
            .setYRot(builder.getModel().head.yRot)
            .setZRot(builder.getModel().head.zRot)
            .animate('Linear', progress_soulleft);

        }


    });
});