PalladiumEvents.registerAnimations((event) => {
    event.register('hyperior_ground_slam', 20, (builder) => {
        var progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:hyperior', 'ground_slam_trigger', builder.getPartialTicks());
        if (progress > 0 && !builder.isFirstPerson()) {
            builder.get('body')
            .setXRotDegrees(-105)
            .setYRotDegrees(0)
            .setZRotDegrees(0)
            .setZ(10)
            .setY(12)
            .animate('InOutCubic', progress)

            builder.get('left_leg')
            .setXRotDegrees(-90)
            .setYRotDegrees(0)
            .setZRotDegrees(0)
            .animate('InOutCubic', progress)
            builder.get('right_leg')
            .setXRotDegrees(-45)
            .setYRotDegrees(0)
            .setZRotDegrees(0)
            .animate('InOutCubic', progress)

            builder.get('head')
            .setXRotDegrees(-60)
            .setYRotDegrees(0)
            .setZRotDegrees(0)
            .animate('InOutCubic', progress)

            builder.get('left_arm')
            .setXRotDegrees(-105)
            .setYRotDegrees(0)
            .setZRotDegrees(0)
            .animate('InOutCubic', progress)
        
            builder.get('right_arm')
            .setXRotDegrees(-90)
            .setYRotDegrees(60)
            .setZRotDegrees(-25)
            .animate('InOutCubic', progress)
        } else if (progress > 0 && builder.isFirstPerson()) {
            builder.get('left_arm')
            .setYRotDegrees(-40)
            .animate('InOutCubic', progress)
        
            builder.get('right_arm')
            .setYRotDegrees(40)
            .animate('InOutCubic', progress)
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('hyperior_throat_grab', 15, (builder) => {
        if (palladium.abilities.isEnabled(builder.getPlayer(), 'arrzenhanced:hyperior', 'throat_grab')) {
            if (!builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setXRot(-45)
                    .setYRot(0)
                    .setZRot(0)
            }
        }
    })
});

PalladiumEvents.registerAnimations((event) => {
    event.register('hyperior_break_restraints', 30, (builder) => {
        if (!palladium.abilities.isEnabled(builder.getPlayer(), 'arrzenhanced:hyperior', 'break_restraints_anim')) {return}
        var progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:hyperior', 'break_restraints_anim', builder.getPartialTicks());
        if (!builder.isFirstPerson()) {
            if (progress >= 0) {
                builder.get('head')
                    .setXRotDegrees(30)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                if ((Math.trunc(progress * 10) / 10) % 0.1 == 0) {
                    builder.get('left_arm')
                        .setZRotDegrees(10)
                    builder.get('right_arm')
                        .setZRotDegrees(-10)
                } else {
                    builder.get('left_arm')
                        .setZRotDegrees(0)
                    builder.get('right_arm')
                        .setZRotDegrees(0)
                }
            }
        } else if (builder.isFirstPerson()) {
            if (progress >= 0) {
                builder.get('left_arm')
                    .setYRotDegrees(-40)
                builder.get('right_arm')
                    .setYRotDegrees(40)
            }
        }
    });
    event.register('hyperior_broke_restraints', 20, (builder) => {
        if (!palladium.abilities.isEnabled(builder.getPlayer(), 'arrzenhanced:hyperior', 'broke_restraints_anim')) {return}
        var progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:hyperior', 'broke_restraints_anim', builder.getPartialTicks());
        if (!builder.isFirstPerson()) {
            if (progress > 0) {
                builder.get('head')
                    .setXRotDegrees(-15)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', progress)
                builder.get('left_arm')
                    .setXRotDegrees(-90)
                    .setYRotDegrees(-90)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', progress)
                builder.get('right_arm')
                    .setXRotDegrees(-90)
                    .setYRotDegrees(90)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', progress)
            }
        } else if (builder.isFirstPerson()) {
            if (progress > 0) {
                builder.get('left_arm')
                    .setYRotDegrees(0)
                builder.get('right_arm')
                    .setYRotDegrees(0)
            }
        }
    });
});