PalladiumEvents.registerAnimations((event) => {
    event.register('injector_right', 30, (builder) => {
        let right_inject_progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:injector', 'injector_right', builder.getPartialTicks());

        if (right_inject_progress > 0.0 && right_inject_progress < 0.85) {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('left_arm')
                    .setXRotDegrees(-50)
                    .animate('InOutCubic', right_inject_progress);

                builder.get('right_arm')
                    .setXRotDegrees(-80)
                    .setYRotDegrees(30)
                    .setZRotDegrees(-90)
                    .animate('InOutCubic', right_inject_progress);
            }
        } else {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('left_arm')
                    .setXRotDegrees(-50)
                    .animate('InOutCubic', right_inject_progress);

                builder.get('right_arm')
                    .setXRotDegrees(-70)
                    .setYRotDegrees(30)
                    .setZRotDegrees(-90)
                    .animate('InOutCubic', right_inject_progress);
            }
        }
    });

    event.register('injector_left', 30, (builder) => {
        let left_inject_progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:injector', 'injector_left', builder.getPartialTicks());

        if (left_inject_progress > 0.0 && left_inject_progress < 0.85) {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('right_arm')
                    .setXRotDegrees(-50)
                    .animate('InOutCubic', left_inject_progress);

                builder.get('left_arm')
                    .setXRotDegrees(-80)
                    .setYRotDegrees(-30)
                    .setZRotDegrees(90)
                    .animate('InOutCubic', left_inject_progress);
            }
        } else {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('right_arm')
                    .setXRotDegrees(-50)
                    .animate('InOutCubic', left_inject_progress);

                builder.get('left_arm')
                    .setXRotDegrees(-70)
                    .setYRotDegrees(-30)
                    .setZRotDegrees(90)
                    .animate('InOutCubic', left_inject_progress);
            }
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('dna_injector_right', 30, (builder) => {
        let right_inject_progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:dna_normalizer', 'injector_right', builder.getPartialTicks());

        if (right_inject_progress > 0.0 && right_inject_progress < 0.85) {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('left_arm')
                    .setXRotDegrees(-50)
                    .animate('InOutCubic', right_inject_progress);

                builder.get('right_arm')
                    .setXRotDegrees(-80)
                    .setYRotDegrees(30)
                    .setZRotDegrees(-90)
                    .animate('InOutCubic', right_inject_progress);
            }
        } else {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('left_arm')
                    .setXRotDegrees(-50)
                    .animate('InOutCubic', right_inject_progress);

                builder.get('right_arm')
                    .setXRotDegrees(-70)
                    .setYRotDegrees(30)
                    .setZRotDegrees(-90)
                    .animate('InOutCubic', right_inject_progress);
            }
        }
    });

    event.register('dna_injector_left', 30, (builder) => {
        let left_inject_progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:dna_normalizer', 'injector_left', builder.getPartialTicks());

        if (left_inject_progress > 0.0 && left_inject_progress < 0.85) {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('right_arm')
                    .setXRotDegrees(-50)
                    .animate('InOutCubic', left_inject_progress);

                builder.get('left_arm')
                    .setXRotDegrees(-80)
                    .setYRotDegrees(-30)
                    .setZRotDegrees(90)
                    .animate('InOutCubic', left_inject_progress);
            }
        } else {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('right_arm')
                    .setXRotDegrees(-50)
                    .animate('InOutCubic', left_inject_progress);

                builder.get('left_arm')
                    .setXRotDegrees(-70)
                    .setYRotDegrees(-30)
                    .setZRotDegrees(90)
                    .animate('InOutCubic', left_inject_progress);
            }
        }
    });
});