
PalladiumEvents.registerAnimations((event) => {
            event.register('arrzee/power_negation', 10, (builder) => {
                const progress_fall = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:deadzone_armor', 'fall_anim', builder.getPartialTicks());
        
                if (progress_fall > 0.0) {
            if (!builder.isFirstPerson()) {
                builder.get('head')
        	    .setXRotDegrees(-50)
                .animate('InOutCubic', progress_fall);

                builder.get('body')
        	    .setXRotDegrees(-60)
                .moveY(-5)
                .moveZ(10)
                .animate('InOutCubic', progress_fall);
    
                builder.get('right_arm')
                .setZRotDegrees(60)
                .setXRotDegrees(0)
                .setYRotDegrees(0)
                .setX(-6)
                .animate('InOutCubic', progress_fall);
    
                builder.get('left_arm')
                .setZRotDegrees(-60)
                .setXRotDegrees(0)
                .setYRotDegrees(0)
                .setX(6)
                .animate('InOutCubic', progress_fall);
    
            builder.get('left_leg')
                .setZRotDegrees(-20)
                .setXRotDegrees(22.5)
                .moveZ(0.5)
                .moveX(1.2)
                .animate('InOutCubic', progress_fall);
    
            builder.get('right_leg')
                .setZRotDegrees(20)
                .setXRotDegrees(22.5)
                .moveZ(0.5)
                .moveX(-1.2)
                .animate('InOutCubic', progress_fall);
            }
            if (builder.isFirstPerson()) {
                builder.get('left_arm')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('InOutCubic', progress_fall);

                builder.get('right_arm')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('InOutCubic', progress_fall);
            }
        }

    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/power_negation_field', 1, (builder) => {
        let progress_hexios_daggers = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:power_negation', 'forcefield', builder.getPartialTicks());

        if (progress_hexios_daggers > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
                builder.get('right_arm')
                .moveY(2)
                .moveZ(0)
                .moveX(0)
                .setXRotDegrees(0)
                .setZRotDegrees(0)
                .setYRotDegrees(30)
                    .animate('InOutBounce', progress_hexios_daggers);

                    builder.get('left_arm')
                    .moveY(2)
                    .moveZ(0)
                    .moveX(0)
                    .setXRotDegrees(0)
                    .setZRotDegrees(0)
                    .setYRotDegrees(-30)
                        .animate('InOutBounce', progress_hexios_daggers);
            } else {
                // do third-person animations
                const halfPi = 1.57079632679;
                builder.get('right_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi)
                    .setYRot(builder.getModel().head.yRot + 0.3)
					.setZRot(builder.getModel().head.zRot + 0.3)
                    .animate('InOutBounce', progress_hexios_daggers);

                    builder.get('left_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi)
                    .setYRot(builder.getModel().head.yRot - 0.3)
					.setZRot(builder.getModel().head.zRot - 0.3)
                    .animate('InOutBounce', progress_hexios_daggers);
            }
        }

    });
});