PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/defender', 1, (builder) => {
        let progress_shield_right = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:rainbow_defender', 'shield_r_hold_anim', builder.getPartialTicks());

        if (progress_shield_right > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
                builder.get('right_arm')
                    .moveY(-2)
                    .moveZ(0)
                    .moveX(-8)
                    .setXRotDegrees(-60)
                    .setZRotDegrees(-70)
                    .setYRotDegrees(10)
                    .animate('InOutBounce', progress_shield_right);
            } else {
                // do third-person animations
                builder.get('right_arm')
                    .setXRotDegrees(-50)
                    .setZRotDegrees(0)
                    .setYRotDegrees(-70)
                    .animate('InOutBounce', progress_shield_right);
            }
        }

        let progress_shield_left = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:rainbow_defender', 'shield_l_hold_anim', builder.getPartialTicks());

        if (progress_shield_left > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
                builder.get('left_arm')
                .moveY(-2)
                .moveZ(0)
                .moveX(8)
                .setXRotDegrees(-60)
                .setZRotDegrees(70)
                .setYRotDegrees(-10)
                    .animate('InOutBounce', progress_shield_left);
            } else {
                // do third-person animations
                builder.get('left_arm')
                .setXRotDegrees(-50)
                .setZRotDegrees(0)
                .setYRotDegrees(70)
                    .animate('InOutBounce', progress_shield_left);
            }
        }

        let progress_prism_blade_right = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:iron_prism', 'prism_blade_r_anim', builder.getPartialTicks());

        if (progress_prism_blade_right > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('right_arm')
                .setXRotDegrees(-65)
                .setZRotDegrees(-10)
                .setYRotDegrees(-65)
                    .animate('InOutBounce', progress_prism_blade_right);
            }
        }

        let progress_prism_blade_left = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:iron_prism', 'prism_blade_l_anim', builder.getPartialTicks());

        if (progress_prism_blade_left > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('left_arm')
                .setXRotDegrees(-65)
                .setZRotDegrees(10)
                .setYRotDegrees(65)
                    .animate('InOutBounce', progress_prism_blade_left);
            }
        }

    });
});