PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/soul_fire_magic', 10, (builder) => {
        let progress_hexios_daggers = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:soul_fire_magic', 'dagger_anim', builder.getPartialTicks());

        if (progress_hexios_daggers > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('right_arm')
                    .moveY(-1)
                    .moveZ(-1)
                    .setXRotDegrees(-110)
                    .setZRotDegrees(-60)
                    .setYRotDegrees(-10)
                    .animate('InOutBounce', progress_hexios_daggers);

                    builder.get('left_arm')
                    .moveY(-1)
                    .moveZ(-1)
                    .setXRotDegrees(-90)
                    .setZRotDegrees(60)
                    .setYRotDegrees(-40)
                    .animate('InOutBounce', progress_hexios_daggers);
            }
        }

    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/soul_fire_magic_field', 10, (builder) => {
        let progress_hexios_daggers = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:soul_fire_magic', 'forcefield', builder.getPartialTicks());

        if (progress_hexios_daggers > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
                builder.get('right_arm')
                .moveY(2)
                .moveZ(0)
                .moveX(0)
                .setXRotDegrees(0)
                .setZRotDegrees(0)
                .setYRotDegrees(30)
                    .animate('InOutBounce', progress_hexios_daggers);

                    builder.get('left_arm')
                    .moveY(2)
                    .moveZ(0)
                    .moveX(0)
                    .setXRotDegrees(0)
                    .setZRotDegrees(0)
                    .setYRotDegrees(-30)
                        .animate('InOutBounce', progress_hexios_daggers);
            } else {
                // do third-person animations
                const halfPi = 1.57079632679;
                builder.get('right_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi)
                    .setYRot(builder.getModel().head.yRot + 0.3)
					.setZRot(builder.getModel().head.zRot + 0.3)
                    .animate('InOutBounce', progress_hexios_daggers);

                    builder.get('left_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi)
                    .setYRot(builder.getModel().head.yRot - 0.3)
					.setZRot(builder.getModel().head.zRot - 0.3)
                    .animate('InOutBounce', progress_hexios_daggers);
            }
        }

    });
});