function convertToRoman(num) {
    var roman = {
      M: 1000,
      CM: 900,
      D: 500,
      CD: 400,
      C: 100,
      XC: 90,
      L: 50,
      XL: 40,
      X: 10,
      IX: 9,
      V: 5,
      IV: 4,
      I: 1
    };
    var str = '';
  
    for (var i of Object.keys(roman)) {
      var q = Math.floor(num / roman[i]);
      num -= q * roman[i];
      str += i.repeat(q);
    }
  
    return str;
}

ItemEvents.tooltip((event) => {

    // Neat utility to display NBT in the tooltip
    /*
    event.addAdvanced(Ingredient.all, (item, advanced, text) => {
        if (event.alt && item.nbt) {
            text.add(Text.of('NBT: ').append(Text.prettyPrintNbt(item.nbt)))
        }
    })
    */
    
    var velocityTooltips = [
        "arrzenhanced:velocity_injector"
    ]
    event.addAdvanced(velocityTooltips, (item, advanced, text) => {
        if (item.nbt) {
            let vint = (Number(item.nbt?.level) + 1) < 10 ? (Number(item.nbt?.level) + 1) : convertToRoman(Number(item.nbt?.level) + 1)
            text.add(
                1,
                Text.of('Velocity ').white()
                .append(Text.of(String(vint)).white())
            )
        } else {
            text.add(
                1,
                Text.of('Velocity ?').white()
            )
        }
    })

    var serumTooltips = [
        "arrzenhanced:velocity_serum"
    ]
    event.addAdvanced(serumTooltips, (item, advanced, text) => {
        if (item.nbt) {
            let vint = (Number(item.nbt?.level) + 1) < 10 ? (Number(item.nbt?.level) + 1) : convertToRoman(Number(item.nbt?.level) + 1)
            text.add(
                1,
                Text.of('Velocity ').white()
                .append(Text.of(String(vint)).white())
            )
        } else {
            text.add(
                1,
                Text.of('Velocity ?').white()
            )
        }
    })

    var arrow_nbts = [
        "base_count",
        "explosive_count",
        "healing_count",
        "diamond_count",
        "ender_pearl_count",
        "knockback_count",
        "dampening_count",
        "essentium_count"
    ].reverse()

    var arrow_names = {
        "base_count": "Basic Arrow",
        "explosive_count": "Explosive Arrow",
        "healing_count": "Healing Arrow",
        "diamond_count": "Diamond Arrow",
        "ender_pearl_count": "Ender Pearl Arrow",
        "knockback_count": "Knockback Arrow",
        "dampening_count": "Dampening Arrow",
        "essentium_count": "Essentium Arrow"
    }
    
    event.addAdvanced('arrzenhanced:iron_prism_chestplate', (item, advanced, text) => {
        if (item.nbt) {
            arrow_nbts.forEach(element => {
                let currArrow = item.nbt.getDouble(element)
                if (currArrow == 0) {return}
                text.add(
                    1,
                    Text.of(String(currArrow) + 'x ').white()
                    .append(Text.of(arrow_names[element]).white())
                )
            })
        }
    })


})