PalladiumEvents.registerAnimations((event) => {
    event.register('witherblade_leap', 20, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:witherblade', 'leap_anim', builder.getPartialTicks());
        if (progress > 0 && !builder.isFirstPerson()) {
            builder.get('chest')
            .setXRotDegrees(80)
            .moveY(8)
            .moveZ(-4)
            
            builder.get('head')
            .moveY(8)
            .moveZ(-3.5)

            builder.get('left_arm')
            .moveY(6)
            .moveZ(-3)
            .setXRotDegrees(-90)
            .setYRotDegrees(-20)
            .setZRotDegrees(0)
        
            builder.get('right_arm')
            .moveY(6)
            .moveZ(-3)
            .setXRotDegrees(-90)
            .setYRotDegrees(20)
            .setZRotDegrees(0)

            builder.get('left_leg')
            .moveY(-2)
            .moveZ(8.25)
            .setXRotDegrees(80)
            .setYRotDegrees(10)
            .setZRotDegrees(10)
        
            builder.get('right_leg')
            .moveY(-2)
            .moveZ(8.25)
            .setXRotDegrees(80)
            .setYRotDegrees(-10)
            .setZRotDegrees(-10)
        } else if (progress > 0 && builder.isFirstPerson()) {
            builder.get('left_arm')
            .setXRotDegrees(-10.5)
            .setYRotDegrees(32.5)
            .setZRotDegrees(40)
            .setX(5)
            .setY(0)
            .setZ(6)
        
            builder.get('right_arm')
            .setXRotDegrees(-10.5)
            .setYRotDegrees(-32.5)
            .setZRotDegrees(-40)
            .setX(-5)
            .setY(0)
            .setZ(6)
        }

        /*
        
        if (progress > 0) {
            builder.get('chest')
            .setXRotDegrees(80)
            .moveY(2)
            .moveZ(-4)
            
            builder.get('head')
            .moveZ(-3.5)

            builder.get('left_arm')
            .moveZ(-3)
            .setXRotDegrees(-90)
            .setYRotDegrees(-20)
            .setZRotDegrees(0)
        
            builder.get('right_arm')
            .moveZ(-3)
            .setXRotDegrees(-90)
            .setYRotDegrees(20)
            .setZRotDegrees(0)

            builder.get('left_leg')
            .moveY(-8)
            .moveZ(8.25)
            .setXRotDegrees(80)
            .setYRotDegrees(10)
            .setZRotDegrees(10)
        
            builder.get('right_leg')
            .moveY(-8)
            .moveZ(8.25)
            .setXRotDegrees(80)
            .setYRotDegrees(-10)
            .setZRotDegrees(-10)
        }
        */
        
    });

    event.register('witherblade_block', 20, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:witherblade', 'block_anim', builder.getPartialTicks());
        if (progress > 0 && !builder.isFirstPerson()) {
            builder.get('left_arm')
            .setXRotDegrees(-90)
            .setYRotDegrees(40)
            .setZRotDegrees(45)
        
            builder.get('right_arm')
            .setXRotDegrees(-90)
            .setYRotDegrees(-40)
            .setZRotDegrees(-45)
        } else if (progress > 0 && builder.isFirstPerson()) {
            builder.get('left_arm')
            .setXRotDegrees(-50)
            .setYRotDegrees(10)
            .setZRotDegrees(40)
            .setX(1)
            .setY(0)
            .setZ(2.5)
        
            builder.get('right_arm')
            .setXRotDegrees(-50)
            .setYRotDegrees(-10)
            .setZRotDegrees(-40)
            .setX(-1)
            .setY(0)
            .setZ(2.5)
        }
    });

    event.register('witherblade_slash', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:witherblade', 'slash_anim', builder.getPartialTicks());
        if (progress < 1/4 && !builder.isFirstPerson() && abilityUtil.isEnabled(builder.getPlayer(), "arrzenhanced:witherblade", "wither_slash")) {
            builder.get('left_arm')
            .setXRotDegrees(-90)
            .setYRotDegrees(10)
            .setZRotDegrees(0)
        
            builder.get('right_arm')
            .setXRotDegrees(-110)
            .setYRotDegrees(-10)
            .setZRotDegrees(0)
        } else if (progress < 1/4 && builder.isFirstPerson() && abilityUtil.isEnabled(builder.getPlayer(), "arrzenhanced:witherblade", "wither_slash")) {
            builder.get('left_arm')
            .setXRotDegrees(-50)
            .setYRotDegrees(30)
            .setZRotDegrees(0)
            .setX(1)
            .setY(0)
            .setZ(8)
        
            builder.get('right_arm')
            .setXRotDegrees(-50)
            .setYRotDegrees(-10)
            .setZRotDegrees(0)
            .setX(-1)
            .setY(0)
            .setZ(8)
        } else if (progress < 2/4 && !builder.isFirstPerson() && abilityUtil.isEnabled(builder.getPlayer(), "arrzenhanced:witherblade", "wither_slash")) {
            builder.get('left_arm')
            .setXRotDegrees(-110)
            .setYRotDegrees(10)
            .setZRotDegrees(0)
        
            builder.get('right_arm')
            .setXRotDegrees(-90)
            .setYRotDegrees(-10)
            .setZRotDegrees(0)
        } else if (progress < 2/4 && builder.isFirstPerson() && abilityUtil.isEnabled(builder.getPlayer(), "arrzenhanced:witherblade", "wither_slash")) {
            builder.get('left_arm')
            .setXRotDegrees(-50)
            .setYRotDegrees(10)
            .setZRotDegrees(0)
            .setX(1)
            .setY(0)
            .setZ(8)
        
            builder.get('right_arm')
            .setXRotDegrees(-50)
            .setYRotDegrees(-30)
            .setZRotDegrees(0)
            .setX(-1)
            .setY(0)
            .setZ(8)
        } else if (progress < 3/4 && !builder.isFirstPerson() && abilityUtil.isEnabled(builder.getPlayer(), "arrzenhanced:witherblade", "wither_slash")) {
            builder.get('left_arm')
            .setXRotDegrees(-90)
            .setYRotDegrees(10)
            .setZRotDegrees(0)
        
            builder.get('right_arm')
            .setXRotDegrees(-110)
            .setYRotDegrees(-10)
            .setZRotDegrees(0)
        } else if (progress < 3/4 && builder.isFirstPerson() && abilityUtil.isEnabled(builder.getPlayer(), "arrzenhanced:witherblade", "wither_slash")) {
            builder.get('left_arm')
            .setXRotDegrees(-50)
            .setYRotDegrees(30)
            .setZRotDegrees(0)
            .setX(1)
            .setY(0)
            .setZ(8)
        
            builder.get('right_arm')
            .setXRotDegrees(-50)
            .setYRotDegrees(-10)
            .setZRotDegrees(0)
            .setX(-1)
            .setY(0)
            .setZ(8)
        } else if (progress < 4/4 && !builder.isFirstPerson() && abilityUtil.isEnabled(builder.getPlayer(), "arrzenhanced:witherblade", "wither_slash")) {
            builder.get('left_arm')
            .setXRotDegrees(-110)
            .setYRotDegrees(10)
            .setZRotDegrees(0)
        
            builder.get('right_arm')
            .setXRotDegrees(-90)
            .setYRotDegrees(-10)
            .setZRotDegrees(0)
        } else if (progress < 4/4 && builder.isFirstPerson() && abilityUtil.isEnabled(builder.getPlayer(), "arrzenhanced:witherblade", "wither_slash")) {
            builder.get('left_arm')
            .setXRotDegrees(-50)
            .setYRotDegrees(10)
            .setZRotDegrees(0)
            .setX(1)
            .setY(0)
            .setZ(8)
        
            builder.get('right_arm')
            .setXRotDegrees(-50)
            .setYRotDegrees(-30)
            .setZRotDegrees(0)
            .setX(-1)
            .setY(0)
            .setZ(8)
        }
    });
});