ServerEvents.commandRegistry(event => {
    const { commands: Commands, arguments: Arguments } = event;

    event.register(
        Commands.literal('codetp')
            .executes(ctx => {
                let player = ctx.source.entity;

                if (!player) {
                    ctx.source.sendFailure('Only entities can run this command.');
                    return 0;
                }
                if (!palladium.superpowers.hasSuperpower(player, 'arrzenhanced:wrath_entity')) {
                    ctx.source.sendFailure('Only entities can run this command.');
                    return 0;
                }

                let server = ctx.source.getServer()
                let dimension = server.getLevel('arrzenhanced:the_code')
                // player.tell(dimension)

                if (!dimension) {
                    ctx.source.sendFailure('Dimension arrzenhanced:the_code does not exist.');
                    return 0;
                }

                let particle = Utils.particleOptions('dust 0 0 0 1');
                player.getLevel().spawnParticles(particle, true, player.getX(), player.getY() + 1, player.getZ(), 0.8, 0.8, 0.8, 150, 0);

                player.teleportTo('arrzenhanced:the_code', 33.5, 129, 11.5, 0, 0);
                ctx.source.sendSuccess('Returned to The Code.', true);

                return 1;
            })
    );
});
