function toRadians(deg) {
    return deg * (JavaMath.PI / 180)
}

ItemEvents.rightClicked('arrzenhanced:orange_batarang', (event) => {
    // event.server.tell()
    var entity = event.entity
    // event.entity.getLevel().playSound(null, entity.getX(), entity.getY(), entity.getZ(), 'minecraft:block.dispenser.launch', 'master', 1, 1);

    try {
        let yawOffset = 15,
        pitchOffset = 25,
        frontOffset = 0,
        speed = 1.5

        var projectile = entity.block.createEntity('palladium:custom_projectile')
        projectile.mergeNbt(
            {
                "Damage": 8,
                "Gravity": 0.01,
                "Appearances": [
                    {
                        "Type": "item",
                        "Item": "arrzenhanced:orange_batarang"
                    }
                    // ,
                    // {
                    //     "Type": "renderLayer",
                    //     "RenderLayer": "arrzenhanced:orange_bat/batarang"
                    // }
                ]
            }
        )

        var pitch = -toRadians(entity.getPitch() + pitchOffset);
        var yaw = -toRadians(entity.getYaw() + yawOffset);

        var x = entity.getX() + Math.cos(pitch) * Math.sin(yaw),
        y = entity.getY() + entity.getEyeHeight() + Math.sin(pitch),
        z = entity.getZ() + Math.cos(pitch) * Math.cos(yaw);

        if (frontOffset != -999) {
            x = entity.getX() + (Math.cos(pitch) * Math.sin(yaw)) + (frontOffset * Math.sin(yaw)),
            y = entity.getY() + entity.getEyeHeight() + Math.sin(pitch),
            z = entity.getZ() + (Math.cos(pitch) * Math.cos(yaw)) + (frontOffset * Math.cos(yaw));
        }
        
        projectile.setPos(x, y, z)
        projectile.setDeltaMovement(entity.getLookAngle().scale(speed))
        projectile.setRotation(-entity.getYaw(), -entity.getPitch())

        projectile.setOwner(entity)
        projectile.spawn()
    } catch (err) {
        entity.tell(err)
    }

    if (!event.entity.isCreative()) {
        let hand = event.hand
        if (hand == 'MAIN_HAND') {
            event.entity.mainHandItem.count--
        }
        else if (hand == 'OFF_HAND') {
            event.entity.offHandItem.count--
        }
    }
})