var BuiltInRegistries = Java.loadClass("net.minecraft.core.registries.BuiltInRegistries")

EntityEvents.death(event => {
    var { entity, source } = event
    //
    if (entity.type == "minecraft:player") {
        let allPowers = palladium.powers.getPowerIdsForNamespace(entity, 'arrzenhanced'),
        hasPowers = false,
        hasCurrentPowers = false,
        ignorePowers = ['arrzenhanced:concussed', 'arrzenhanced:incognito', 'arrzenhanced:shocked']
        allPowers.forEach(power => {
            if (palladium.superpowers.hasSuperpower(entity, power) == true && !ignorePowers.includes(power.toString())) {hasPowers = true}
        })
        if (palladium.superpowers.hasSuperpower(entity, 'arrzenhanced:electricity_conduction') == true) {hasCurrentPowers = true}
        if (source.type().msgId() == 'gamma_radiation' && hasCurrentPowers) {
            var hasVelocity = false;
            var hasGammaRadiation = false;
            if (entity.activeEffects.size() > 0) {
                entity.activeEffects.toArray().forEach((iteratedEffect) => {
                    var currentEffectPath = BuiltInRegistries.MOB_EFFECT.getKey(iteratedEffect.effect).toString()
                    // entity.tell(currentEffectPath)
                    if (currentEffectPath == 'arrzenhanced:velocity') {
                        hasVelocity = true;
                    } else if (currentEffectPath == 'arrzenhanced:gamma_radiation') {
                        hasGammaRadiation = true;
                    }
                })
            }
            if (hasVelocity && hasGammaRadiation) {
                entity.removeEffect('arrzenhanced:velocity')
                // entity.removeEffect('arrzenhanced:gamma_radiation')
                entity.health = 4
                
                entity.potionEffects.add('minecraft:regeneration', 4*20, 100, false, false)
                entity.potionEffects.add('minecraft:blindness', 5*20, 100, false, false)
                entity.potionEffects.add('minecraft:weakness', 5*20, 100, false, false)
                palladium.superpowers.removeSuperpower(entity, "arrzenhanced:electricity_conduction")
                palladium.superpowers.addSuperpower(entity, "arrzenhanced:electric_gamma_radiation")
                entity.getLevel().spawnParticles("minecraft:firework", true, entity.getX(), entity.getY() + 1, entity.getZ(), 5, 5, 5, 250, 0)
                event.cancel()
            }
        }
    }
})