EntityEvents.death(event => {
    if (event.entity.getType() === 'minecraft:phantom') {
        let source = event.source;
        if (source && source.getType() === 'player') {
            let player = source.actual;
            let currentCount = player.persistentData.getInt('phantom_kills') == undefined ? 0 : player.persistentData.getInt('phantom_kills');

            if (currentCount <= 5) {
                let allPowers = palladium.powers.getPowerIdsForNamespace(player, 'arrzenhanced'),
                hasPowers = false,
                ignorePowers = ['arrzenhanced:concussed', 'arrzenhanced:incognito', 'arrzenhanced:shocked']
                allPowers.forEach(power => {
                    if (palladium.superpowers.hasSuperpower(player, power) == true && !ignorePowers.includes(power.toString())) {hasPowers = true}
                })
                if (!hasPowers) {
                    let hasStrength = false
                    if (player.activeEffects.size() > 0) {
                        player.activeEffects.toArray().forEach((iteratedEffect) => {
                            let amp = iteratedEffect.getAmplifier()
                            var currentEffectPath = BuiltInRegistries.MOB_EFFECT.getKey(iteratedEffect.effect).toString()
                            if (currentEffectPath == 'minecraft:strength' && amp >= 1) {hasStrength = true}
                        })
                    }
                    if (hasStrength) {
                        player.persistentData.putInt('phantom_kills', currentCount + 1);
                    }
                }
            }
        }
    }
});

PlayerEvents.tick((event) => {
    var player = event.player
    if (player.isSleepingLongEnough()) {
        let currentCount = player.persistentData.getInt('phantom_kills') == undefined ? 0 : player.persistentData.getInt('phantom_kills');
        
        if (currentCount >= 3) {
            let allPowers = palladium.powers.getPowerIds(player),
            hasPowers = false,
            ignorePowers = ['arrzenhanced:concussed', 'arrzenhanced:incognito', 'arrzenhanced:shocked']
            allPowers.forEach(power => {
                if (palladium.superpowers.hasSuperpower(player, power) == true && !ignorePowers.includes(power.toString())) {hasPowers = true}
            })
            if (!hasPowers) {
                let hasStrength = false
                if (player.activeEffects.size() > 0) {
                    player.activeEffects.toArray().forEach((iteratedEffect) => {
                        var currentEffectPath = BuiltInRegistries.MOB_EFFECT.getKey(iteratedEffect.effect).toString()
                        if (currentEffectPath == 'minecraft:strength') {hasStrength = true}
                    })
                }
                if (hasStrength) {
                    player.removeEffect('minecraft:strength')
                    player.potionEffects.add('minecraft:blindness', 3*20, 100, false, false)
                    palladium.superpowers.addSuperpower(player, "arrzenhanced:napturgy")
                    player.getLevel().spawnParticles("minecraft:firework", true, player.getX(), player.getY() + 1, player.getZ(), 5, 5, 5, 250, 0)
                    // event.server.runCommandSilent(`playsound minecraft:item.totem.use ambient @a[distance=..10] ${player.getX()} ${player.getY() + 1} ${player.getZ()} 1 1`)
                    event.player.stopSleeping()
                }
            }
        } else {
            player.persistentData.putInt('phantom_kills', 0);
        }
    }
})
