EntityEvents.death(event => {
    let entity = event.entity
    if (entity.type == "minecraft:player") {
        let allPowers = palladium.powers.getPowerIdsForNamespace(entity, 'arrzenhanced'),
        hasPowers = false,
        metConditions = false,
        ignorePowers = ['arrzenhanced:concussed', 'arrzenhanced:incognito', 'arrzenhanced:shocked']
        allPowers.forEach(power => {
            if (palladium.superpowers.hasSuperpower(entity, power) == true && !ignorePowers.includes(power.toString())) {hasPowers = true}
        })
        if (entity.mainHandItem.id == "arrzenhanced:nanotech_circuit" || entity.offHandItem.id == "arrzenhanced:nanotech_circuit") {
            metConditions = true
        }
        
        if (metConditions && !hasPowers) {
            event.server.runCommandSilent(`playsound minecraft:item.totem.use player @a ${entity.getX()} ${entity.getY()} ${entity.getZ()}`)
            event.server.runCommandSilent(`particle minecraft:totem_of_undying ${entity.getX()} ${entity.getY()} ${entity.getZ()} 0.5 1 0.5 1 800`)

            if (entity.mainHandItem.id == "arrzenhanced:nanotech_circuit") {
                entity.mainHandItem.count--
            } else if (entity.offHandItem.id == "arrzenhanced:nanotech_circuit") {
                entity.offHandItem.count--
            }
                
            entity.potionEffects.add('minecraft:blindness', 3*20, 100, false, false)
            entity.potionEffects.add('minecraft:weakness', 3*20, 100, false, false)
            entity.potionEffects.add('minecraft:slowness', 30*20, 100, false, false)

            palladium.superpowers.addSuperpower(entity, "arrzenhanced:circuit")
            entity.health = 6
            event.cancel()
        }
    }
})