var BuiltInRegistries = Java.loadClass("net.minecraft.core.registries.BuiltInRegistries")

EntityEvents.hurt(event => {
    var { entity, source } = event
    if (entity.type == "minecraft:player") {
        let allPowers = palladium.powers.getPowerIdsForNamespace(entity, 'arrzenhanced'),
        hasPowers = false,
        ignorePowers = ['arrzenhanced:concussed', 'arrzenhanced:incognito', 'arrzenhanced:shocked']
        allPowers.forEach(power => {
            if (palladium.superpowers.hasSuperpower(entity, power) == true && !ignorePowers.includes(power.toString())) {hasPowers = true}
        })
        if (source.type().msgId() == 'lightningBolt') { // struck by lightning
            var hasLevitation = false;
            var hasSwiftness = false;
            if (entity.activeEffects.size() > 0) {
                entity.activeEffects.toArray().forEach((iteratedEffect) => {
                    var currentEffectPath = BuiltInRegistries.MOB_EFFECT.getKey(iteratedEffect.effect).toString()
                    if (currentEffectPath == 'minecraft:levitation') {
                        hasLevitation = true;
                    } else if (currentEffectPath == 'minecraft:speed') {
                        hasSwiftness = true;
                    }
                })
            }
            if (hasLevitation && hasSwiftness && !hasPowers) {
                entity.removeEffect('minecraft:levitation')
                entity.removeEffect('minecraft:speed')
                
                entity.potionEffects.add('minecraft:blindness', 3*20, 100, false, false)
                entity.potionEffects.add('minecraft:weakness', 3*20, 100, false, false)
                palladium.superpowers.addSuperpower(entity, "arrzenhanced:impasse")
            }
        }
    }
})

ServerEvents.recipes(event => {
    event.shaped(
        Item.of(`arrzenhanced:impasse_helmet`, 1),
        [
            "   ",
            "ABA",
            "   "
        ],
        {
            A: '#forge:ingots/copper',
            B: '#forge:ingots/titanium'
        }
    )
    event.shaped(
        Item.of(`arrzenhanced:impasse_chestplate`, 1),
        [
            "B B",
            "ADA",
            "CBC"
        ],
        {
            A: '#forge:ingots/copper',
            B: '#forge:ingots/titanium',
            C: 'minecraft:lightning_rod',
            D: 'palladium:lead_flux_capacitor'
        }
    )
    event.shaped(
        Item.of(`arrzenhanced:impasse_leggings`, 1),
        [
            "CBC",
            "B B",
            "B B"
        ],
        {
            B: '#forge:ingots/titanium',
            C: 'minecraft:lightning_rod'
        }
    )
    event.shaped(
        Item.of(`arrzenhanced:impasse_boots`, 1),
        [
            "C C",
            "B B",
            "A A"
        ],
        {
            A: '#forge:ingots/copper',
            B: '#forge:ingots/titanium',
            C: 'minecraft:lightning_rod'
        }
    )
});