// PlayerEvents.tick((event) => {
//     if (event.entity) {
//         let player = event.entity
//         if (player.getXpLevel() >= 50) {
//             let world = event.getEntity().getServer()
//             let pData = world.persistentData
//             if (pData.get('orange_lantern_spawned') === true) {return}
            
//             player.tell("\u00A76As your greed knows no bounds, you spot a ring flying towards you...")
//             player.tell("\u00A76It's yours, only yours, and forever yours! Nobody else's!")
//             player.give('arrzenhanced:orange_ring')
//             player.tags.add('Arrz.HideAlienFace')
//             pData.put('orange_lantern_spawned', true)
//             pData.put('orange_lantern_uuid', player.uuid.toString())
//         }
//     }
// })

PlayerEvents.tick((event) => {
    // arrz.fallen_stormbreaker
    if (event.entity) {
        let player = event.entity
        let myBoundingBox = player.getBoundingBox()
        player.getLevel().getEntitiesWithin(myBoundingBox).forEach(target => {
            if (target == player) return
            if (target.tags.contains('arrz.fallen_stormbreaker')) {
                let allPowers = palladium.powers.getPowerIdsForNamespace(player, 'arrzenhanced'),
                hasPowers = false,
                metConditions = false,
                ignorePowers = ['arrzenhanced:concussed', 'arrzenhanced:incognito', 'arrzenhanced:shocked']
                allPowers.forEach(power => {
                    if (palladium.superpowers.hasSuperpower(player, power) == true && !ignorePowers.includes(power.toString())) {hasPowers = true}
                })

                var hasHero = false;
                if (player.activeEffects.size() > 0) {
                    player.activeEffects.toArray().forEach((iteratedEffect) => {
                        var currentEffectPath = BuiltInRegistries.MOB_EFFECT.getKey(iteratedEffect.effect).toString()
                        if (currentEffectPath == 'minecraft:hero_of_the_village') {
                            hasHero = true;
                        }
                    })
                }
                if (hasHero && !hasPowers) {
                    palladium.superpowers.addSuperpower(player, "arrzenhanced:asgardian_demigod")
                    player.give('arrzenhanced:stormbreaker')
                    player.tags.add('Arrz.HasStormbreaker')
                    player.setItemSlot(2, Item.of('arrzenhanced:sabri_boots'))
                    player.setItemSlot(3, Item.of('arrzenhanced:sabri_leggings'))
                    player.setItemSlot(4, Item.of('arrzenhanced:sabri_chestplate'))
                    
                    for (var i = 0; i < 3; i++) {
                        var px = player.getX();
                        var py = player.getY();
                        var pz = player.getZ();
                        var level = player.getLevel()
                        var mob = level.createEntity("minecraft:lightning_bolt");
                        mob.setPosition(px, py+1, pz);
                        mob.spawn();
                    }
                    
                    target.kill()
                }
            }
        })
    }
})