var BuiltInRegistries = Java.loadClass("net.minecraft.core.registries.BuiltInRegistries")

EntityEvents.hurt(event => {
    var { entity, source } = event
    if (entity.type == "minecraft:player") {
        let allPowers = palladium.powers.getPowerIdsForNamespace(entity, 'arrzenhanced'),
        hasPowers = false,
        ignorePowers = ['arrzenhanced:concussed', 'arrzenhanced:incognito', 'arrzenhanced:shocked']
        allPowers.forEach(power => {
            if (palladium.superpowers.hasSuperpower(entity, power) == true && !ignorePowers.includes(power.toString())) {hasPowers = true}
        })
        if (source.type().msgId() == 'lightningBolt') { // struck by lightning
            var hasRegen = false;
            var hasSwiftness = false;
            var hasFireRes = false;
            var negativeSpeed = false;
            if (entity.activeEffects.size() > 0) {
                entity.activeEffects.toArray().forEach((iteratedEffect) => {
                    var currentEffectPath = BuiltInRegistries.MOB_EFFECT.getKey(iteratedEffect.effect).toString()
                    // entity.tell(currentEffectPath)
                    if (currentEffectPath == 'minecraft:regeneration') {
                        hasRegen = true;
                    } else if (currentEffectPath == 'minecraft:speed') {
                        hasSwiftness = true;
                    } else if (currentEffectPath == 'minecraft:fire_resistance') {
                        hasFireRes = true;
                    } else if (currentEffectPath == 'minecraft:strength') {
                        negativeSpeed = true;
                    }
                })
            }
            if (hasRegen && hasSwiftness && hasFireRes && !hasPowers) {
                entity.removeEffect('minecraft:regeneration')
                entity.removeEffect('minecraft:speed')
                entity.removeEffect('minecraft:fire_resistance')
                palladium.setProperty(entity, 'arrzenhanced.maxSpeed', 1);
                palladium.setProperty(entity, 'arrzenhanced.speedColor', 0);
                if (negativeSpeed) {
                    entity.removeEffect('minecraft:strength')
                    palladium.setProperty(entity, 'arrzenhanced.speedColor', 5);
                    palladium.setProperty(entity, 'arrzenhanced.oldSpeedColor', 5);
                }
                
                entity.potionEffects.add('minecraft:blindness', 3*20, 100, false, false)
                entity.potionEffects.add('minecraft:weakness', 3*20, 100, false, false)
                palladium.superpowers.addSuperpower(entity, "arrzenhanced:speedforce")
            }
        }
    }
})