var playingSounds = {}; // Tracks the currently playing sound for each player
var missingPowerTicks = {}; // Tracks how long an entity has lacked the power
var soundTimers = {}; // Tracks the duration of the currently playing sound

ServerEvents.tick((event) => {
    return
    // event.server.tell(event)
    event.server.getPlayers().forEach(player => {
        var activeAbility = null;

        // Find the first enabled instance
        palladium.abilities.getEntries(player, 'arrzenhanced:speed_run_sound').forEach(ability => {
            if (ability.isEnabled() && !activeAbility) {
                activeAbility = ability;
            }
        });

        // var isMoving = player.xo !== player.getX() || player.yo !== player.getY() || player.zo !== player.getZ();
        // event.server.tell(player.getTotalMovementSpeed())
        // event.server.tell(isMoving)

        if (activeAbility) {
            // event.server.tell(soundTimers[player.id])
            var sound = activeAbility.getPropertyByName('sound');
            var volume = activeAbility.getPropertyByName('volume') || 1.0;
            var pitch = activeAbility.getPropertyByName('pitch') || 1.0;

            if (!sound) return; // Failsafe

            // Reset missing power counter
            missingPowerTicks[player.id] = 0;

            // Initialize or update sound timer
            if (soundTimers[player.id] == undefined || soundTimers[player.id] >= 80) {
                // Stop the previous sound (if any)
                if (playingSounds[player.id]) {
                    event.server.runCommandSilent(`stopsound ${player.getGameProfile().getName()} master ${playingSounds[player.id]}`);
                }

                // Play the new sound
                var px = player.getX(),
                py = player.getY(),
                pz = player.getZ()
                event.server.runCommandSilent(`playsound ${sound} master @a ${px} ${py} ${pz} 1 ${pitch}`); 
                playingSounds[player.id] = sound;
                soundTimers[player.id] = 0; // Reset timer
            } else {
                soundTimers[player.id]++; // Increment sound duration tracker
            }
        } else {
            // Increase missing power counter
            missingPowerTicks[player.id] = (missingPowerTicks[player.id] || 0) + 1;

            // Stop sound if power is missing for 3+ ticks
            if (missingPowerTicks[player.id] >= 3 && playingSounds[player.id]) {
                event.server.runCommandSilent(`stopsound ${player.getGameProfile().getName()} master ${playingSounds[player.id]}`);
                delete playingSounds[player.id];
                delete missingPowerTicks[player.id];
                delete soundTimers[player.id];
            }
        }
    });
});
