EntityEvents.hurt(event => {
    var source = event.source.actual;
    var target = event.entity;

    // Ensure the source is an entity (not a block, projectile, etc.)
    if (!source || !source.isLiving() || !target || !target.isLiving()) return;
    if (target.type != 'minecraft:player') return;
    palladium.abilities.getEntries(target, 'arrzenhanced:block_damage').forEach(ability => {
        if (!ability.isEnabled()) return
        var desiredAngle = Number(ability.getPropertyByName('angle'))

        // Get the player's position and look vector
        var targetPos = { x: target.getX(), y: target.getY(), z: target.getZ() };
        var lookVector = target.getLookAngle(); // Vector3d
    
        // Get the source's position
        var sourcePos = { x: source.getX(), y: source.getY(), z: source.getZ() };
    
        // Calculate the direction vector from the target to the source
        var directionToSource = {
            x: sourcePos.x - targetPos.x,
            y: sourcePos.y - targetPos.y,
            z: sourcePos.z - targetPos.z,
        };
    
        // Normalize the direction vector
        var magnitude = Math.sqrt(
            (directionToSource.x ** 2) +
            (directionToSource.y ** 2) +
            (directionToSource.z ** 2)
        );
    
        if (magnitude === 0 || isNaN(magnitude)) {
            console.error("Invalid magnitude:", magnitude, directionToSource);
            return;
        }
    
        directionToSource.x /= magnitude;
        directionToSource.y /= magnitude;
        directionToSource.z /= magnitude;
    
        // Calculate the dot product between the look vector and the direction to the source
        var dotProduct = (
            (lookVector.x() * directionToSource.x) +
            (lookVector.y() * directionToSource.y) +
            (lookVector.z() * directionToSource.z)
        );
    
        // Clamp the dot product to the valid range
        dotProduct = Math.max(-1, Math.min(1, dotProduct));
    
        // Calculate the angle in degrees
        var angleDegrees = Math.acos(dotProduct) * (180 / JavaMath.PI);
        // target.tell(angleDegrees)
    
        // Check if the angle is within the 135-degree arc (67.5 degrees from the center)
        if (angleDegrees <= desiredAngle) {
            event.cancel();
        } else {
            let src = event.getSource()
            // console.log(src)
            // event.cancel()
        }
    })
});