EntityEvents.hurt(event => {
    var source = event.source.actual;
    var target = event.entity;

    // Ensure the source is an entity (not a block, projectile, etc.)
    if (!source || !source.isLiving() || !target || !target.isLiving()) return;
    if (target.type != 'minecraft:player') return;
    palladium.abilities.getEntries(target, 'arrzenhanced:block_damage').forEach(ability => {
        if (!ability.isEnabled()) return
        var desiredAngle = Number(ability.getPropertyByName('angle'))

        // Get the player's position and look vector
        var targetPos = { x: target.getX(), y: target.getY(), z: target.getZ() };
        var lookVector = target.getLookAngle(); // Vector3d
    
        // Get the source's position
        var sourcePos = { x: source.getX(), y: source.getY(), z: source.getZ() };
    
        // Calculate the direction vector from the target to the source
        var directionToSource = {
            x: sourcePos.x - targetPos.x,
            y: sourcePos.y - targetPos.y,
            z: sourcePos.z - targetPos.z,
        };
    
        // Normalize the direction vector
        var magnitude = Math.sqrt(
            (directionToSource.x ** 2) +
            (directionToSource.y ** 2) +
            (directionToSource.z ** 2)
        );
    
        if (magnitude === 0 || isNaN(magnitude)) {
            console.error("Invalid magnitude:", magnitude, directionToSource);
            return;
        }
    
        directionToSource.x /= magnitude;
        directionToSource.y /= magnitude;
        directionToSource.z /= magnitude;
    
        // Calculate the dot product between the look vector and the direction to the source
        var dotProduct = (
            (lookVector.x() * directionToSource.x) +
            (lookVector.y() * directionToSource.y) +
            (lookVector.z() * directionToSource.z)
        );
    
        // Clamp the dot product to the valid range
        dotProduct = Math.max(-1, Math.min(1, dotProduct));
    
        // Calculate the angle in degrees
        var angleDegrees = Math.acos(dotProduct) * (180 / JavaMath.PI);
        // target.tell(angleDegrees)
    
        // Check if the angle is within the 135-degree arc (67.5 degrees from the center)
        if (angleDegrees <= desiredAngle) {
            event.cancel();
        } else {
            let src = event.getSource()
            // console.log(src)
            // event.cancel()
        }
    })
    palladium.abilities.getEntries(target, 'arrzenhanced:forcefield').forEach(ability => {
        if (!ability.isEnabled()) return
        var desiredAngle = 90

        // Get the player's position and look vector
        var targetPos = { x: target.getX(), y: target.getY(), z: target.getZ() };
        var lookVector = target.getLookAngle(); // Vector3d
    
        // Get the source's position
        var sourcePos = { x: source.getX(), y: source.getY(), z: source.getZ() };
    
        // Calculate the direction vector from the target to the source
        var directionToSource = {
            x: sourcePos.x - targetPos.x,
            y: sourcePos.y - targetPos.y,
            z: sourcePos.z - targetPos.z,
        };
    
        // Normalize the direction vector
        var magnitude = Math.sqrt(
            (directionToSource.x ** 2) +
            (directionToSource.y ** 2) +
            (directionToSource.z ** 2)
        );
    
        if (magnitude === 0 || isNaN(magnitude)) {
            console.error("Invalid magnitude:", magnitude, directionToSource);
            return;
        }
    
        directionToSource.x /= magnitude;
        directionToSource.y /= magnitude;
        directionToSource.z /= magnitude;
    
        // Calculate the dot product between the look vector and the direction to the source
        var dotProduct = (
            (lookVector.x() * directionToSource.x) +
            (lookVector.y() * directionToSource.y) +
            (lookVector.z() * directionToSource.z)
        );
    
        // Clamp the dot product to the valid range
        dotProduct = Math.max(-1, Math.min(1, dotProduct));
    
        // Calculate the angle in degrees
        var angleDegrees = Math.acos(dotProduct) * (180 / JavaMath.PI);
        // target.tell(angleDegrees)
    
        // Check if the angle is within the 135-degree arc (67.5 degrees from the center)
        if (angleDegrees <= desiredAngle) {
            event.cancel();
        } else {
            let src = event.getSource()
            // console.log(src)
            // event.cancel()
        }
    })

    if (
        ((target.mainHandItem.id == 'arrzenhanced:speedburst_shield' || target.offHandItem.id == 'arrzenhanced:speedburst_shield') && (target.isBlocking())) ||
        ((target.mainHandItem.id == 'arrzenhanced:cordaxe_shield' || target.offHandItem.id == 'arrzenhanced:cordaxe_shield') && (target.isBlocking())) ||
        ((target.mainHandItem.id == 'arrzenhanced:tachyon_shield' || target.offHandItem.id == 'arrzenhanced:tachyon_shield') && (target.isBlocking()))
    ) {
        var ratio = 1/10
        if (source.mainHandItem.id == 'arrzenhanced:essentium_spear') {
            ratio = 4/10
        } else if (source.mainHandItem.id == 'arrzenhanced:construct_mace') {
            ratio = 6/10
        } else if (source.mainHandItem.id == 'arrzenhanced:deadzone_dagger') {
            ratio = 15/100
        } else if (source.mainHandItem.id == 'arrzenhanced:phantom_knight_sword') {
            ratio = 4/10
        } else if (source.mainHandItem.id == 'arrzenhanced:prism_blade') {
            ratio = 4/10
        }
        if (Math.random() < ratio) {
            // target.addItemCooldown('arrzenhanced:speedburst_shield', 50)
            // target.addItemCooldown('arrzenhanced:cordaxe_shield', 50)
            // target.addItemCooldown('arrzenhanced:tachyon_shield', 50)
            target.disableShield(true)
            event.cancel()
        } else {
            event.cancel()
        }
    }
    
    let attackingEntity = event.source.player
    if (attackingEntity) {
        if (attackingEntity?.mainHandItem?.id == 'arrzenhanced:deadzone_dagger') {
            event.entity.potionEffects.add("dampened:dark_matter", (2.5*60)*20, 0, false, false)
            event.entity.potionEffects.add("dampened:genetic", (2.5*60)*20, 0, false, false)
            event.entity.potionEffects.add("dampened:dampen", (2.5*60)*20, 0, false, false)
            event.entity.potionEffects.add("dampened:emp", (2.5*60)*20, 0, false, false)
        }
    }
    
    if (target) {
        // target.tell(event.source.getDirectEntity())
        // target.tell(source)
        if (palladium.superpowers.hasSuperpower(target, 'arrzenhanced:wrath_entity') && source?.mainHandItem?.id.includes('netherite')) {
            event.entity.potionEffects.add("dampened:code", (1*60)*20, 0, false, false)
        }
    }

    palladium.abilities.getEntries(source, 'arrzenhanced:shock_punch').forEach(ability => {
        if (!ability.isEnabled()) return
        if (!event.source.type().msgId().includes('player')) return
        
        if (!target?.potionEffects) return
        /*
        palladium.abilities.getEntries(target, 'arrzenhanced:forcefield').forEach(ability => {
            if (!ability.isEnabled()) return
        })
        */
        target.potionEffects.add('arrzenhanced:shocked', 5 * 20, 0, false, false)
    })
});
