var REGENERATION_COOLDOWN = 120;
var REGENERATION_TIME = 120;

let ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');

EntityEvents.hurt(event => {
    if (event.entity.type == 'minecraft:player') {
        if (event.entity.tags.contains('Arrz.Witherblade.Regenerating')) {
            event.cancel()
        }
    }
})

var regenTimers = {}
var regenCountdowns = {}
PlayerEvents.tick(event => {
    // runs on each player once a tick
    if (
        regenTimers.hasOwnProperty(event.entity.id) ||
        event.entity.tags.contains('Arrz.Witherblade.Regenerating')
    ) { // if we're regenerating
        if (!regenTimers.hasOwnProperty(event.entity.id)) {regenTimers[event.entity.id] = REGENERATION_TIME}
        regenTimers[event.entity.id]--;
        event.entity.potionEffects.add("minecraft:darkness", 2, 255, true, false) // keep us blind
        event.entity.potionEffects.add("minecraft:slowness", 2, 255, true, false) // keep us still
        event.entity.potionEffects.add("minecraft:weakness", 2, 255, true, false) // keep us weak
        event.entity.potionEffects.add("minecraft:invisibility", 2, 255, true, false) // keep us invis
        if (event.entity.motionY > 0) {
            event.entity.motionY = 0
            event.entity.connection.send(new ClientboundSetEntityMotionPacket(event.entity));
        } 
        if (event.entity.age % 10) {
            var px = event.entity.getX();
            var py = event.entity.getY() + 0.25;
            var pz = event.entity.getZ();
            
            event.server.runCommandSilent(`particle block redstone_block ${px} ${py} ${pz} 0 0 0 5 500`)
        }
        if (regenTimers[event.entity.id] <= 0 || !regenTimers[event.entity.id]) {
            event.entity.tags.remove('Arrz.Witherblade.Regenerating')
            delete regenTimers[event.entity.id]
        }

    } else if (
        regenCountdowns.hasOwnProperty(event.entity.id) || event.entity.tags.contains('Arrz.Witherblade.FirstDeath')
    ) {
        if (!regenCountdowns.hasOwnProperty(event.entity.id)) {regenCountdowns[event.entity.id] = REGENERATION_COOLDOWN}
        let playerId = event.entity.id
        regenCountdowns[playerId]--;
        if (regenCountdowns[playerId] <= 0) {
            let targetPlayer = event.entity
            if (targetPlayer.tags.contains('Arrz.Witherblade.FirstDeath')) {
                // remove tag
                targetPlayer.tags.remove('Arrz.Witherblade.FirstDeath')
                // playsound
                var level = targetPlayer.getLevel()
                level.playSound(null, targetPlayer.getX(), targetPlayer.getY(), targetPlayer.getZ(), "minecraft:block.note_block.pling", "master", 20, 2)
                // level.playSound(null, targetPlayer.getX(), targetPlayer.getY(), targetPlayer.getZ(), "hertz_heroes:heartbeat", "master", 20, 1)
                // remove or reset
                delete regenCountdowns[playerId]
            }
        }
    }
})

EntityEvents.death(event => {
    if (event.source.getType() == "genericKill") return;

    let powers = abilityUtil.getEntries(event.entity, "arrzenhanced:rapid_regeneration")

    if (powers.length > 0) {
        if (event.entity.tags.contains('Arrz.Witherblade.FirstDeath')) {
            event.entity.tags.remove('Arrz.Witherblade.FirstDeath')
            delete regenCountdowns[event.entity.id]
        } else {
            event.entity.health = 1
            event.entity.tags.add('Arrz.Witherblade.FirstDeath')
            event.entity.tags.add('Arrz.Witherblade.Regenerating')
            regenCountdowns[event.entity.id] = REGENERATION_COOLDOWN
            regenTimers[event.entity.id] = REGENERATION_TIME
            // event.entity.tell(event.source)
            event.cancel()
        }
    }
})