var $IntegerProperty = Java.loadClass("net.minecraft.world.level.block.state.properties.IntegerProperty")
var $BooleanProperty = Java.loadClass("net.minecraft.world.level.block.state.properties.BooleanProperty")

StartupEvents.registry('block', (e) => {
    e.create('dampened:dampening_block')
    .displayName('Dampening Block')
    .mapColor('metal')
    .soundType('metal')
    .hardness(12.0)
    .resistance(12.0)
    .requiresTool(true)
    .item(item => {
        item.tooltip(Text.translate("tooltip.dampened.dampens.dark_matter"))
        item.tooltip(Text.translate("tooltip.dampened.dampens.genetic"))
    })
    .property($IntegerProperty.create("size", 0, 32))
    .property($BooleanProperty.create("powered"))
    .defaultState((state) => {
        state.set($IntegerProperty.create("size", 0, 32), 10)
        state.set($BooleanProperty.create("powered"), false)
    })
    .tagBlock('minecraft:mineable/pickaxe')
    .tagBlock('minecraft:needs_diamond_tool')
    .textureAll('dampened:block/dampening_block')
    .blockEntity((c) => {
        c.serverTick(1, 0, (blockEntity) => {
            // runs every 1 ticks
            if (global.dampenTick) {
                global.dampenTick(blockEntity)
            }
        })
    })
    
    e.create('dampened:emp_block')
    .displayName('EMP Jammer')
    .mapColor('metal')
    .soundType('metal')
    .hardness(12.0)
    .resistance(12.0)
    .requiresTool(true)
    .item(item => {
        item.tooltip(Text.translate("tooltip.dampened.dampens.tech"))
    })
    .property($IntegerProperty.create("size", 0, 32))
    .property($BooleanProperty.create("powered"))
    .defaultState((state) => {
        state.set($IntegerProperty.create("size", 0, 32), 10)
        state.set($BooleanProperty.create("powered"), false)
    })
    .tagBlock('minecraft:mineable/pickaxe')
    .tagBlock('minecraft:needs_diamond_tool')
    .textureAll('dampened:block/emp_block')
    .blockEntity((c) => {
        c.serverTick(1, 0, (blockEntity) => {
            // runs every 1 ticks
            if (global.empTick) {
                global.empTick(blockEntity)
            }
        })
    })
    
    e.create('dampened:magic_rune')
    .displayName('Magic Rune')
    .mapColor('metal')
    .soundType('metal')
    .hardness(12.0)
    .resistance(12.0)
    .requiresTool(true)
    .item(item => {
        item.tooltip(Text.translate("tooltip.dampened.dampens.magic"))
    })
    .property($IntegerProperty.create("size", 0, 32))
    .property($BooleanProperty.create("powered"))
    
    .defaultState((state) => {
        state.set($IntegerProperty.create("size", 0, 32), 10)
        state.set($BooleanProperty.create("powered"), true)
    })
    .tagBlock('minecraft:mineable/pickaxe')
    .tagBlock('minecraft:needs_diamond_tool')
    .textureAll('dampened:block/magic_rune')
    .blockEntity((c) => {
        c.serverTick(1, 0, (blockEntity) => {
            // runs every 1 ticks
            if (global.magicRune) {
                global.magicRune(blockEntity)
            }
        })
    })
    
    e.create('dampened:creative_dampening_block')
    .displayName('Creative Dampening Block')
    .mapColor('metal')
    .soundType('metal')
    .hardness(128.0)
    .resistance(128.0)
    .requiresTool(true)
    .item(item => {
        item.tooltip(Text.translate("tooltip.dampened.dampens.all"))
    })
    .property($IntegerProperty.create("size", 0, 32))
    .property($BooleanProperty.create("powered"))
    .defaultState((state) => {
        state.set($IntegerProperty.create("size", 0, 32), 10)
        state.set($BooleanProperty.create("powered"), true)
    })
    .textureAll('dampened:block/magic_rune')
    .blockEntity((c) => {
        c.serverTick(1, 0, (blockEntity) => {
            // runs every 1 ticks
            if (global.chaosWard) {
                global.chaosWard(blockEntity)
            }
        })
    })
})

function resolveAllegedBooleanFromObject(thing) {
    if (thing.toString() == 'true') { return true; }
    if (thing.toString() == 'false') { return false; }
    return null
}

global.chaosWard = (blockEntity) => {
    let level = blockEntity.level
    let {x, y, z} = blockEntity
    let dampenSize = Number(level.getBlock(x, y, z).properties.get("size"))
    let vertSize = (dampenSize - 3) < 0 ? dampenSize : dampenSize - 3
    level.getEntitiesWithin(AABB.of(
        x + dampenSize,
        y + vertSize,
        z + dampenSize,
        x - dampenSize,
        y - vertSize,
        z - dampenSize
    )).forEach(target => {
        if (!target?.potionEffects) return
        target.potionEffects.add("dampened:magic", 2 * 20, 0, false, false)
        target.potionEffects.add("dampened:dark_matter", 2 * 20, 0, false, false)
        target.potionEffects.add("dampened:genetic", 2 * 20, 0, false, false)
        target.potionEffects.add("dampened:dampen", 2 * 20, 0, false, false)
        target.potionEffects.add("dampened:emp", 2 * 20, 0, false, false)
        target.potionEffects.add("dampened:code", 2 * 20, 0, false, false)
        target.potionEffects.add("dampened:kryptonite", 2 * 20, 0, false, false)
    });
}

global.magicRune = (blockEntity) => {
    let level = blockEntity.level
    let {x, y, z} = blockEntity

    let block = level.getBlock(x, y, z)
    let newSignal = level.hasNeighborSignal(block.getPos())
    let flag = block.properties.get("powered")
    if (flag != level.hasNeighborSignal(block)) {
        block.set(block.getId(), {
            powered: newSignal
        });
    }
    
    let active = resolveAllegedBooleanFromObject(level.getBlock(x, y, z).properties.get("powered"))
    if (!active) {return}
    let dampenSize = Number(level.getBlock(x, y, z).properties.get("size"))
    let vertSize = (dampenSize - 3) <= 0 ? dampenSize : dampenSize - 3
    level.getEntitiesWithin(AABB.of(
        x + dampenSize,
        y + vertSize,
        z + dampenSize,
        x - dampenSize,
        y - vertSize,
        z - dampenSize
    )).forEach(target => {
        if (!target?.potionEffects) return
        target.potionEffects.add("dampened:magic", 2 * 20, 0, false, false)
    });
}

global.dampenTick = (blockEntity) => {
    let level = blockEntity.level
    let {x, y, z} = blockEntity

    let block = level.getBlock(x, y, z)
    let newSignal = level.hasNeighborSignal(block.getPos())
    let flag = block.properties.get("powered")
    if (flag != level.hasNeighborSignal(block)) {
        block.set(block.getId(), {
            powered: newSignal
        });
    }

    let active = resolveAllegedBooleanFromObject(level.getBlock(x, y, z).properties.get("powered"))
    if (!active) {return}
    let dampenSize = Number(level.getBlock(x, y, z).properties.get("size"))
    let vertSize = (dampenSize - 3) <= 0 ? dampenSize : dampenSize - 3
    level.getEntitiesWithin(AABB.of(
        x + dampenSize,
        y + vertSize,
        z + dampenSize,
        x - dampenSize,
        y - vertSize,
        z - dampenSize
    )).forEach(target => {
        if (!target?.potionEffects) return
        target.potionEffects.add("dampened:dark_matter", 2 * 20, 0, false, false)
        target.potionEffects.add("dampened:genetic", 2 * 20, 0, false, false)
        // target.potionEffects.add("dampened:dampen", 2 * 20, 0, false, false)
    });
}

global.empTick = (blockEntity) => {
    let level = blockEntity.level
    let {x, y, z} = blockEntity

    let block = level.getBlock(x, y, z)
    let newSignal = level.hasNeighborSignal(block.getPos())
    let flag = block.properties.get("powered")
    if (flag != level.hasNeighborSignal(block)) {
        block.set(block.getId(), {
            powered: newSignal
        });
    }

    let active = resolveAllegedBooleanFromObject(level.getBlock(x, y, z).properties.get("powered"))
    if (!active) {return}
    let dampenSize = Number(level.getBlock(x, y, z).properties.get("size"))
    let vertSize = (dampenSize - 3) <= 0 ? dampenSize : dampenSize - 3
    level.getEntitiesWithin(AABB.of(
        x + dampenSize,
        y + vertSize,
        z + dampenSize,
        x - dampenSize,
        y - vertSize,
        z - dampenSize
    )).forEach(target => {
        if (!target?.potionEffects) return
        target.potionEffects.add("dampened:emp", 2 * 20, 0, false, false)
    });
}

let dampenBlocks = [
    'dampened:dampening_block',
    'dampened:emp_block'
];

ForgeEvents.onEvent("net.minecraftforge.event.level.BlockEvent$NeighborNotifyEvent", event => {
    let block = event.getLevel().getBlock(event.getPos())
    let bs = block.getBlockState()

    if (dampenBlocks.includes(bs.getBlock().getId())) {
        let newSignal = event.getLevel().hasNeighborSignal(event.pos)
        block.set(block.getId(), {
            powered: newSignal
        });
    }
});