/*
    @author Hertz
    @version 1.0
*/

function getDamageSource(
    /** @type {Internal.Level}*/ level,
    /** @type {Internal.DamageType_}*/ damageType
    ) {
    const $ResourceLocation = Java.loadClass('net.minecraft.resources.ResourceLocation');
    const $ResourceKey = Java.loadClass("net.minecraft.resources.ResourceKey")
    const DAMAGE_TYPE = $ResourceKey.createRegistryKey("damage_type")

    const resourceKey = $ResourceKey.create(DAMAGE_TYPE, Utils.id(damageType))
    const holder = level.registryAccess().registryOrThrow(DAMAGE_TYPE).getHolderOrThrow(resourceKey)
    var damagesource = holder.get()
    return new DamageSource(damagesource)
}

StartupEvents.registry('mob_effect', event => {
    event.create('dampened:dark_matter')
        .displayName("Dark Matter Dampening")
        .color(0xFFC8AC)
        .harmful()
        .effectTick((entity, lvl) => global.darkMatterDampen(entity, lvl));
    event.create('dampened:univirus')
        .displayName('Univirus')
        .color(0xBEFD08)
        .harmful()
        .effectTick((entity, lvl) => global.univirus(entity, lvl));
    event.create('dampened:genetic')
        .displayName('Genetic Mutation Suppression')
        .color(0x4287F5)
        .harmful()
        .effectTick((entity, lvl) => global.genericDampen(entity, lvl));
    event.create('dampened:code')
        .displayName('Code Magic Dampening')
        .color(0xFF0000)
        .harmful()
        .effectTick((entity, lvl) => global.genericDampen(entity, lvl));
    event.create('dampened:magic')
        .displayName('Magic Dampening')
        .color(0xFF00FF)
        .harmful()
        .effectTick((entity, lvl) => global.genericDampen(entity, lvl));
    event.create('dampened:kryptonite')
        .displayName('Kryptonite Poisoning')
        .color(0x00FF00)
        .harmful()
        .effectTick((entity, lvl) => global.genericDampen(entity, lvl));
    event.create('dampened:emp')
        .displayName('EMP Disruption')
        .color(0x696969)
        .harmful()
        .effectTick((entity, lvl) => global.genericDampen(entity, lvl));
    event.create('dampened:dampen')
        .displayName('Power Suppression')
        .color(0x696969)
        .harmful()
        .effectTick((entity, lvl) => global.genericDampen(entity, lvl));
})


global.darkMatterDampen = (entity, lvl) => {
    if (entity.getLevel().clientSide) return;
    if (entity.age % 20 == 0 && palladium.powers.getPowerIds(entity).length > 0) {
        // entity.attack(damageSource, 2 * lvl);
        // entity.attack(2 * (lvl+1));
    }
}
global.genericDampen = (entity, lvl) => {
    if (entity.getLevel().clientSide) return;
    return;
    if (entity.age % 20 == 0 && palladium.powers.getPowerIds(entity).length > 0) {
        // entity.attack(damageSource, 2 * lvl);
        // entity.attack(2 * (lvl+1));
    }
}
global.univirus = (entity, lvl) => {
    if (entity.getLevel().clientSide) return;
    const damageSource = getDamageSource(entity.getLevel(), "minecraft:generic");

    // Damage based on level
    if (entity.age % 20 == 0 && palladium.powers.getPowerIds(entity).length > 0) {
        entity.attack(damageSource, 2 * (lvl+1));
        // entity.attack(2 * (lvl+1));
    }
}

/*
let $PotionBuilder = Java.loadClass("dev.latvian.mods.kubejs.misc.PotionBuilder")
function potionRegist(e, id, potion_id, durationInSeconds, amplifier) {
    e.createCustom(potion_id, () => {
        return new $PotionBuilder(potion_id)
        .effect(`dampened:${id}`, durationInSeconds * 20, amplifier)
        .createObject()
    })
}
StartupEvents.registry("potion", e => {
    potionRegist(e, 'dark_matter', 'dark_matter', 3 * 60, 0);
    potionRegist(e, 'dark_matter', 'long_dark_matter', 5 * 60, 0);

    potionRegist(e, 'univirus', 'univirus', 3 * 60, 0);
    potionRegist(e, 'univirus', 'long_univirus', 5 * 60, 0);
    potionRegist(e, 'univirus', 'strong_univirus', 1.5 * 60, 1);

    potionRegist(e, 'emp', 'emp', 3 * 60, 0);
    potionRegist(e, 'emp', 'long_emp', 5 * 60, 0);
    potionRegist(e, 'emp', 'strong_emp', 1.5 * 60, 1);

    potionRegist(e, 'genetic', 'genetic', 3 * 60, 0);
    potionRegist(e, 'genetic', 'long_genetic', 5 * 60, 0);

    potionRegist(e, 'dampen', 'dampen', 3 * 60, 0);
    potionRegist(e, 'dampen', 'long_dampen', 5 * 60, 0);
})
*/

ForgeEvents.onEvent('net.minecraftforge.event.entity.living.MobEffectEvent$Remove', event => global.removeEffect(event))
/**
 * 
 * @param {Internal.MobEffectEvent$Remove} event 
 * @returns 
 */
global.removeEffect = event => {
    var fx = [
        "effect.dampened.dark_matter",
        "effect.dampened.univirus",
        "effect.dampened.emp",
        "effect.dampened.dampen",
        "effect.dampened.genetic",
        "effect.dampened.code",
        "effect.dampened.magic",
        "effect.dampened.kryptonite"
    ]
    if (event.entity.deathTime > 0) {return}
    if (!fx.includes(event.effect.descriptionId)) {return}
    event.setCanceled(true)
}